/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.junit.Before;
import org.restlet.data.MediaType;
import org.restlet.engine.util.DefaultSaxHandler;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.RestletTestCase;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class RestletXmlTestCase
extends RestletTestCase {
    private static final String _XML_BODY = "<server protocol=\"HTTP\" port=\"9090\"/>\n<server protocol=\"HTTP\" port=\"9091\"/>\n<defaultHost hostPort=\"9091\">\n<attach uriPattern=\"/abcd\" targetClass=\"org.restlet.test.HelloWorldApplication\"/>\n</defaultHost>\n<host hostPort=\"9090\">\n<attach uriPattern=\"/efgh\" targetClass=\"org.restlet.test.HelloWorldApplication\"/>\n</host>\n</component>\n";
    private static final String BAD_XML = "<?xml version=\"1.0\"?>\n<component xmlns=\"http://www.restlet.org/schemas/2.0/Component\">\n<bad-element bad-attribute=\"some-value\">abcd</bad-element><server protocol=\"HTTP\" port=\"9090\"/>\n<server protocol=\"HTTP\" port=\"9091\"/>\n<defaultHost hostPort=\"9091\">\n<attach uriPattern=\"/abcd\" targetClass=\"org.restlet.test.HelloWorldApplication\"/>\n</defaultHost>\n<host hostPort=\"9090\">\n<attach uriPattern=\"/efgh\" targetClass=\"org.restlet.test.HelloWorldApplication\"/>\n</host>\n</component>\n";
    private static final String XML_WITH_XMLNS = "<?xml version=\"1.0\"?>\n<component xmlns=\"http://www.restlet.org/schemas/2.0/Component\">\n<server protocol=\"HTTP\" port=\"9090\"/>\n<server protocol=\"HTTP\" port=\"9091\"/>\n<defaultHost hostPort=\"9091\">\n<attach uriPattern=\"/abcd\" targetClass=\"org.restlet.test.HelloWorldApplication\"/>\n</defaultHost>\n<host hostPort=\"9090\">\n<attach uriPattern=\"/efgh\" targetClass=\"org.restlet.test.HelloWorldApplication\"/>\n</host>\n</component>\n";
    private static final String XML_WITHOUT_XMLNS = "<?xml version=\"1.0\"?>\n<component>\n<server protocol=\"HTTP\" port=\"9090\"/>\n<server protocol=\"HTTP\" port=\"9091\"/>\n<defaultHost hostPort=\"9091\">\n<attach uriPattern=\"/abcd\" targetClass=\"org.restlet.test.HelloWorldApplication\"/>\n</defaultHost>\n<host hostPort=\"9090\">\n<attach uriPattern=\"/efgh\" targetClass=\"org.restlet.test.HelloWorldApplication\"/>\n</host>\n</component>\n";
    private DocumentBuilder builder;
    private Validator validator;

    private Source getAsSource(String xmlString) {
        return new StreamSource(this.getAsStream(xmlString));
    }

    private InputStream getAsStream(String xmlString) {
        return new ByteArrayInputStream(xmlString.getBytes());
    }

    @Before
    protected void setUp() throws Exception {
        super.setUp();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(true);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        DefaultSaxHandler handler = new DefaultSaxHandler();
        schemaFactory.setErrorHandler((ErrorHandler)handler);
        schemaFactory.setResourceResolver((LSResourceResolver)handler);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/restlet/Component.xsd");
        RestletXmlTestCase.assertNotNull((String)"Component.xsd stream MUST NOT be null", (Object)is);
        StreamSource ss = new StreamSource(is);
        Schema schema = schemaFactory.newSchema(ss);
        dbf.setSchema(schema);
        this.builder = dbf.newDocumentBuilder();
        this.builder.setErrorHandler((ErrorHandler)handler);
        this.builder.setEntityResolver((EntityResolver)handler);
        this.validator = schema.newValidator();
    }

    protected void tearDown() throws Exception {
        this.builder = null;
        this.validator = null;
        super.tearDown();
    }

    public void testParserBadXML() {
        System.out.println("-- testParserBadXML");
        try {
            this.builder.parse(this.getAsStream(BAD_XML));
            RestletXmlTestCase.assertTrue((boolean)true);
        }
        catch (SAXException x) {
            RestletXmlTestCase.fail((String)"MUST be able to parse a good restlet.xml with xmlns attribute");
        }
        catch (IOException x) {
            RestletXmlTestCase.fail((String)"MUST be able to parse a good restlet.xml with xmlns attribute");
        }
    }

    public void testParserWithoutXMLNS() {
        System.out.println("-- testParserWithoutXMLNS");
        try {
            this.builder.parse(this.getAsStream(XML_WITHOUT_XMLNS));
            RestletXmlTestCase.assertTrue((boolean)true);
        }
        catch (SAXException x) {
            RestletXmlTestCase.fail((String)"MUST be able to parse a good restlet.xml without xmlns attribute");
        }
        catch (IOException x) {
            RestletXmlTestCase.fail((String)"MUST be able to parse a good restlet.xml without xmlns attribute");
        }
    }

    public void testParserWithXMLNS() {
        System.out.println("-- testParserWithXMLNS");
        try {
            this.builder.parse(this.getAsStream(XML_WITH_XMLNS));
            RestletXmlTestCase.assertTrue((boolean)true);
        }
        catch (SAXException x) {
            RestletXmlTestCase.fail((String)"MUST be able to parse a good restlet.xml with xmlns attribute");
        }
        catch (IOException x) {
            RestletXmlTestCase.fail((String)"MUST be able to parse a good restlet.xml with xmlns attribute");
        }
    }

    public void testValidateMethod() {
        System.out.println("-- testValidateMethod");
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/restlet/Component.xsd");
        RestletXmlTestCase.assertNotNull((String)"Component.xsd stream MUST NOT be null", (Object)is);
        InputRepresentation schemaRepresentation = new InputRepresentation(is, MediaType.APPLICATION_W3C_SCHEMA);
        DomRepresentation configRepresentation = new DomRepresentation((Representation)new StringRepresentation((CharSequence)XML_WITH_XMLNS));
        try {
            configRepresentation.validate((Representation)schemaRepresentation);
            RestletXmlTestCase.assertTrue((boolean)true);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            RestletXmlTestCase.fail((String)x.getLocalizedMessage());
        }
    }

    public void testValidatorBadXML() {
        System.out.println("-- testValidatorBadXML");
        try {
            this.validator.validate(this.getAsSource(BAD_XML));
            RestletXmlTestCase.fail((String)"MUST NOT be able to validate bad restlet.xml");
        }
        catch (SAXException x) {
            RestletXmlTestCase.assertTrue((String)"MUST detect schema violation", (boolean)x.getLocalizedMessage().startsWith("cvc-complex-type.2.4.a"));
            RestletXmlTestCase.assertTrue((String)"MUST detect schema violation related to 'bad-element'", (x.getLocalizedMessage().indexOf("bad-element") > 0 ? 1 : 0) != 0);
        }
        catch (IOException x) {
            RestletXmlTestCase.fail((String)"MUST throw a SAXException only");
        }
    }

    public void testValidatorWithoutXMLNS() {
        System.out.println("-- testValidatorWithoutXMLNS");
        try {
            this.validator.validate(this.getAsSource(XML_WITHOUT_XMLNS));
            RestletXmlTestCase.fail((String)"MUST NOT be able to validate restlet.xml without xmlns attribute");
        }
        catch (SAXException x) {
            RestletXmlTestCase.assertTrue((boolean)true);
        }
        catch (IOException x) {
            RestletXmlTestCase.fail((String)"");
        }
    }

    public void testValidatorWithXMLNS() {
        System.out.println("-- testValidatorWithXMLNS");
        try {
            this.validator.validate(this.getAsSource(XML_WITH_XMLNS));
            RestletXmlTestCase.assertTrue((boolean)true);
        }
        catch (SAXException x) {
            RestletXmlTestCase.fail((String)"MUST be able to validate restlet.xml with xmlns attribute");
        }
        catch (IOException x) {
            RestletXmlTestCase.fail((String)"MUST be able to validate restlet.xml with xmlns attribute");
        }
    }
}

