/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.test.jaxrs.services.resources.PathParamTestService;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;

public class PathParamTest
extends JaxRsTestCase {
    private Reference createReference2(String subPath) {
        String baseRef = this.createBaseRef() + "/pathParamTest/" + subPath;
        return new Reference(this.createBaseRef(), baseRef);
    }

    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(PathParamTestService.class);
            }
        };
    }

    public void htestCheckUnmodifiable() {
        Response response = this.get(this.createReference2("4711/checkUnmodifiable/1667"));
        PathParamTest.assertTrue((String)("The List annotated with @PathParam must not be modifiable. Status is " + response.getStatus()), (boolean)response.getStatus().isSuccess());
    }

    public void testGet1() throws IOException {
        Response response = this.get(this.createReference2("4711"));
        PathParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest.assertEquals((String)"4711", (String)response.getEntity().getText());
    }

    public void testGet2() throws IOException {
        Response response = this.get(this.createReference2("4711/abc/677/def"));
        PathParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest.assertEquals((String)"4711\n677", (String)response.getEntity().getText());
    }

    public void testGet4() throws IOException {
        Response response = this.get(this.createReference2("12/st/34"));
        PathParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest.assertEquals((String)"34", (String)response.getEntity().getText());
    }

    public void testGetRegExpPathEinBuchstabe() throws IOException {
        Response response = this.get("regExp/a");
        PathParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest.assertEquals((String)"ein Buchstabe: a", (String)response.getEntity().getText());
    }

    public void testGetRegExpPathLangerString() throws IOException {
        Response response = this.get("regExp/aa");
        PathParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest.assertEquals((String)"anderes: aa", (String)response.getEntity().getText());
    }

    public void testGetRegExpPathZahl() throws IOException {
        Response response = this.get("regExp/1");
        PathParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest.assertEquals((String)"Zahl: 1", (String)response.getEntity().getText());
        response = this.get("regExp/112");
        PathParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest.assertEquals((String)"Zahl: 112", (String)response.getEntity().getText());
    }

    public void testGetRegExpPathZahlMinus() throws IOException {
        Response response = this.get("regExp/-1");
        PathParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest.assertEquals((String)"Zahl: -1", (String)response.getEntity().getText());
    }
}

