/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.test.jaxrs.services.resources.PathParamTestService2;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;

public class PathParamTest2
extends JaxRsTestCase {
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(PathParamTestService2.class);
            }
        };
    }

    public void testDecoded1() throws Exception {
        Response response = this.get("decoded/x");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"x", (String)response.getEntity().getText());
        response = this.get("decoded/sjkg");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"sjkg", (String)response.getEntity().getText());
    }

    public void testDecoded2() throws Exception {
        Response response = this.get("decoded/%20");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)" ", (String)response.getEntity().getText());
    }

    public void testEncoded() throws Exception {
        Response response = this.get("encoded/x");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"x", (String)response.getEntity().getText());
        response = this.get("encoded/sjkg");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"sjkg", (String)response.getEntity().getText());
        response = this.get("encoded/%20");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"%20", (String)response.getEntity().getText());
    }

    public void testGetBigDecimal() throws IOException {
        Response response = this.get("BigDecimal/413624654744743534745767");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"413624654744743534745767", (String)response.getEntity().getText());
        response = this.get("BigDecimal/abc");
        PathParamTest2.assertTrue((boolean)response.getStatus().isError());
    }

    public void testGetInt() throws IOException {
        Response response = this.get("int/467");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"467", (String)response.getEntity().getText());
        response = this.get("int/abc");
        PathParamTest2.assertTrue((boolean)response.getStatus().isError());
    }

    public void testGetInteger() throws IOException {
        Response response = this.get("Integer/4423467");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"4423467", (String)response.getEntity().getText());
        response = this.get("Integer/423645365467345743734");
        PathParamTest2.assertTrue((boolean)response.getStatus().isError());
        PathParamTest2.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        response = this.get("Integer/abc");
        PathParamTest2.assertTrue((boolean)response.getStatus().isError());
        PathParamTest2.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
    }

    public void testGetMediaType() throws IOException {
        Response response = this.get("MediaType/467");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"467/*", (String)response.getEntity().getText());
        response = this.get("MediaType/abc");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"abc/*", (String)response.getEntity().getText());
    }

    public void testGetMn() throws IOException {
        Response response = this.get("mn467");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"467", (String)response.getEntity().getText());
        response = this.get("mnabc");
        PathParamTest2.assertTrue((boolean)response.getStatus().isError());
        PathParamTest2.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
    }

    public void testGetWithSlashInUriParam() throws IOException {
        Response response = this.get("multSegm/abc/def");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"abc/def", (String)response.getEntity().getText());
    }

    public void testX() throws Exception {
        Response response = this.get("abc123");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"123", (String)response.getEntity().getText());
        response = this.get("abcdef");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"def", (String)response.getEntity().getText());
    }

    public void testX2() throws Exception {
        Response response = this.get("abcdef/1234");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"bcd\n12", (String)response.getEntity().getText());
        response = this.get("aXYZef/AB34");
        PathParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest2.assertEquals((String)"XYZ\nAB", (String)response.getEntity().getText());
    }
}

