/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.security;

import org.restlet.ext.crypto.DigestVerifier;
import org.restlet.security.MapVerifier;
import org.restlet.security.SecretVerifier;
import org.restlet.test.RestletTestCase;

public class DigestVerifierTestCase
extends RestletTestCase {
    public void test1() {
        MapVerifier mv = new MapVerifier();
        mv.getLocalSecrets().put("scott", "tiger".toCharArray());
        DigestVerifier sdv = new DigestVerifier("SHA-1", (SecretVerifier)mv, null);
        DigestVerifierTestCase.assertTrue((boolean)sdv.verify("scott", "RuPXcqGIjq3/JsetpH/XUC15bgc=".toCharArray()));
    }

    public void test2() {
        MapVerifier mv = new MapVerifier();
        mv.getLocalSecrets().put("scott", "RuPXcqGIjq3/JsetpH/XUC15bgc=".toCharArray());
        DigestVerifier sdv = new DigestVerifier("SHA-1", (SecretVerifier)mv, "SHA-1");
        DigestVerifierTestCase.assertTrue((boolean)sdv.verify("scott", "RuPXcqGIjq3/JsetpH/XUC15bgc=".toCharArray()));
        DigestVerifierTestCase.assertFalse((boolean)sdv.verify("scott", "xxxxx".toCharArray()));
        DigestVerifierTestCase.assertFalse((boolean)sdv.verify("tom", "RuPXcqGIjq3/JsetpH/XUC15bgc=".toCharArray()));
    }

    public void test3() {
        MapVerifier mv = new MapVerifier();
        mv.getLocalSecrets().put("scott", "RuPXcqGIjq3/JsetpH/XUC15bgc=".toCharArray());
        DigestVerifier sdv = new DigestVerifier(null, (SecretVerifier)mv, "SHA-1");
        DigestVerifierTestCase.assertTrue((boolean)sdv.verify("scott", "tiger".toCharArray()));
    }
}

