/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.security;

import org.junit.After;
import org.junit.Before;
import org.restlet.Component;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Status;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.test.RestletTestCase;
import org.restlet.test.security.SaasComponent;

public class SecurityTestCase
extends RestletTestCase {
    private Component component;

    @Before
    public void startComponent() throws Exception {
        this.component = new SaasComponent();
        this.component.start();
    }

    @After
    public void stopServer() throws Exception {
        if (this.component != null && this.component.isStarted()) {
            this.component.stop();
        }
        this.component = null;
    }

    public void testSecurity() {
        try {
            this.startComponent();
            String uri = "http://localhost:" + TEST_PORT + "/test1";
            ClientResource resource = new ClientResource(uri);
            try {
                resource.get();
            }
            catch (ResourceException e) {
                // empty catch block
            }
            resource.release();
            SecurityTestCase.assertEquals((Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)resource.getStatus());
            resource.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "stiger", "pwd"));
            try {
                resource.get();
            }
            catch (ResourceException e) {
                // empty catch block
            }
            resource.release();
            SecurityTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)resource.getStatus());
            uri = "http://localhost:" + TEST_PORT + "/test2";
            resource = new ClientResource(uri);
            try {
                resource.get();
            }
            catch (ResourceException e) {
                // empty catch block
            }
            resource.release();
            SecurityTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)resource.getStatus());
            uri = "http://localhost:" + TEST_PORT + "/test3";
            resource = new ClientResource(uri);
            try {
                resource.get();
            }
            catch (ResourceException e) {
                // empty catch block
            }
            resource.release();
            SecurityTestCase.assertEquals((Object)Status.CLIENT_ERROR_FORBIDDEN, (Object)resource.getStatus());
            uri = "http://localhost:" + TEST_PORT + "/test4";
            resource = new ClientResource(uri);
            resource.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "stiger", "pwd"));
            try {
                resource.get();
            }
            catch (ResourceException e) {
                // empty catch block
            }
            resource.release();
            SecurityTestCase.assertEquals((Object)Status.CLIENT_ERROR_FORBIDDEN, (Object)resource.getStatus());
            resource.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "larmstrong", "pwd"));
            try {
                resource.get();
            }
            catch (ResourceException e) {
                // empty catch block
            }
            resource.release();
            SecurityTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)resource.getStatus());
            uri = "http://localhost:" + TEST_PORT + "/test5";
            resource = new ClientResource(uri);
            resource.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "stiger", "pwd"));
            try {
                resource.get();
            }
            catch (ResourceException e) {
                // empty catch block
            }
            resource.release();
            SecurityTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)resource.getStatus());
            resource.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "larmstrong", "pwd"));
            try {
                resource.get();
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
            resource.release();
            SecurityTestCase.assertEquals((Object)Status.CLIENT_ERROR_FORBIDDEN, (Object)resource.getStatus());
            this.stopServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

