/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test;

import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.RestletTestCase;

public class HeaderTestCase
extends RestletTestCase {
    private static final String HTTP_HEADERS = "org.restlet.http.headers";
    private static final String TEST_HEADER = "testHeader";
    private Component component;
    private Client client;

    private static Form getHttpHeaders(Request request) {
        Form headers = (Form)request.getAttributes().get(HTTP_HEADERS);
        if (headers == null) {
            headers = new Form();
            request.getAttributes().put(HTTP_HEADERS, headers);
        }
        return headers;
    }

    private Response getWithParams(Parameter ... parameters) throws Exception {
        Request request = new Request(Method.GET, "http://localhost:" + TEST_PORT);
        Form headers = HeaderTestCase.getHttpHeaders(request);
        for (Parameter p : parameters) {
            headers.add((Object)p);
        }
        Response result = this.client.handle(request);
        return result;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.client = new Client(Protocol.HTTP);
        if (this.component == null) {
            this.component = new Component();
            this.component.getServers().add(Protocol.HTTP, TEST_PORT);
            this.component.getDefaultHost().attachDefault((Restlet)new TestHeaderRestlet());
        }
        if (!this.component.isStarted()) {
            this.component.start();
        }
    }

    public void tearDown() throws Exception {
        this.client.stop();
        this.component.stop();
        this.component = null;
        super.tearDown();
    }

    public void test0() throws Exception {
        Response response = this.getWithParams(new Parameter[0]);
        HeaderTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HeaderTestCase.assertEquals(null, (String)response.getEntity().getText());
    }

    public void test1() throws Exception {
        Response response = this.getWithParams(new Parameter(TEST_HEADER, "a"));
        HeaderTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HeaderTestCase.assertEquals((String)"a\n", (String)response.getEntity().getText());
    }

    public void test2() throws Exception {
        Response response = this.getWithParams(new Parameter(TEST_HEADER, "a"), new Parameter(TEST_HEADER, "b"));
        HeaderTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HeaderTestCase.assertEquals((String)"a\nb\n", (String)response.getEntity().getText());
    }

    public static class TestHeaderRestlet
    extends Restlet {
        public void handle(Request request, Response response) {
            StringBuilder stb = new StringBuilder();
            Form headers = HeaderTestCase.getHttpHeaders(request);
            for (Parameter header : headers) {
                if (!header.getName().equals(HeaderTestCase.TEST_HEADER)) continue;
                stb.append(header.getValue());
                stb.append('\n');
            }
            response.setEntity((Representation)new StringRepresentation((CharSequence)stb, MediaType.TEXT_PLAIN));
        }
    }
}

