/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.odata;

import java.util.Iterator;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.ext.odata.Query;
import org.restlet.test.RestletTestCase;
import org.restlet.test.ext.odata.cafecustofeeds.Cafe;
import org.restlet.test.ext.odata.cafecustofeeds.CafeCustoFeedsApplication;
import org.restlet.test.ext.odata.cafecustofeeds.CafeCustoFeedsService;
import org.restlet.test.ext.odata.cafecustofeeds.Contact;
import org.restlet.test.ext.odata.cafecustofeeds.Item;

public class ODataCafeCustoFeedsTestCase
extends RestletTestCase {
    private Component component = new Component();
    private CafeCustoFeedsService service;

    protected void setUp() throws Exception {
        super.setUp();
        this.component.getServers().add(Protocol.HTTP, 8111);
        this.component.getClients().add(Protocol.CLAP);
        this.component.getDefaultHost().attach("/CafeCustoFeeds.svc", (Restlet)new CafeCustoFeedsApplication());
        this.component.start();
        this.service = new CafeCustoFeedsService();
    }

    protected void tearDown() throws Exception {
        this.component.stop();
        this.component = null;
        this.service = null;
        super.tearDown();
    }

    public void testQueryCafes() {
        Query<Cafe> query = this.service.createCafeQuery("/Cafes");
        Iterator iterator = query.iterator();
        ODataCafeCustoFeedsTestCase.assertTrue((boolean)iterator.hasNext());
        Cafe cafe = (Cafe)iterator.next();
        ODataCafeCustoFeedsTestCase.assertEquals((String)"1", (String)cafe.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Le Cafe Louis", (String)cafe.getName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Cafe corp.", (String)cafe.getCompanyName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Levallois-Perret", (String)cafe.getCity());
        ODataCafeCustoFeedsTestCase.assertEquals((int)92300, (int)cafe.getZipCode());
        ODataCafeCustoFeedsTestCase.assertTrue((boolean)iterator.hasNext());
        cafe = (Cafe)iterator.next();
        ODataCafeCustoFeedsTestCase.assertEquals((String)"2", (String)cafe.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Le Petit Marly", (String)cafe.getName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Cafe inc.", (String)cafe.getCompanyName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Marly Le Roi", (String)cafe.getCity());
        ODataCafeCustoFeedsTestCase.assertEquals((int)78310, (int)cafe.getZipCode());
    }

    public void testQueryCafesExpandContact() {
        Query<Cafe> query1 = this.service.createCafeQuery("/Cafes");
        Query query2 = query1.expand("Contact");
        Iterator iterator = query2.iterator();
        ODataCafeCustoFeedsTestCase.assertTrue((boolean)iterator.hasNext());
        Cafe cafe = (Cafe)iterator.next();
        ODataCafeCustoFeedsTestCase.assertEquals((String)"1", (String)cafe.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Le Cafe Louis", (String)cafe.getName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Cafe corp.", (String)cafe.getCompanyName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Levallois-Perret", (String)cafe.getCity());
        ODataCafeCustoFeedsTestCase.assertEquals((int)92300, (int)cafe.getZipCode());
        Contact contact = cafe.getContact();
        ODataCafeCustoFeedsTestCase.assertNotNull((Object)contact);
        ODataCafeCustoFeedsTestCase.assertEquals((String)"1", (String)contact.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Agathe Zeblues", (String)contact.getName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Chief", (String)contact.getTitle());
        ODataCafeCustoFeedsTestCase.assertTrue((boolean)iterator.hasNext());
        cafe = (Cafe)iterator.next();
        ODataCafeCustoFeedsTestCase.assertEquals((String)"2", (String)cafe.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Le Petit Marly", (String)cafe.getName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Cafe inc.", (String)cafe.getCompanyName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Marly Le Roi", (String)cafe.getCity());
        ODataCafeCustoFeedsTestCase.assertEquals((int)78310, (int)cafe.getZipCode());
        contact = cafe.getContact();
        ODataCafeCustoFeedsTestCase.assertNotNull((Object)contact);
        ODataCafeCustoFeedsTestCase.assertEquals((String)"2", (String)contact.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Alphonse Denltas", (String)contact.getName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Boss", (String)contact.getTitle());
    }

    public void testQueryCafesExpandItem() {
        Query<Cafe> query1 = this.service.createCafeQuery("/Cafes");
        Query query2 = query1.expand("Items");
        Iterator iterator = query2.iterator();
        ODataCafeCustoFeedsTestCase.assertTrue((boolean)iterator.hasNext());
        Cafe cafe = (Cafe)iterator.next();
        ODataCafeCustoFeedsTestCase.assertEquals((String)"1", (String)cafe.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Le Cafe Louis", (String)cafe.getName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Cafe corp.", (String)cafe.getCompanyName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Levallois-Perret", (String)cafe.getCity());
        ODataCafeCustoFeedsTestCase.assertEquals((int)92300, (int)cafe.getZipCode());
        Iterator<Item> iterator2 = cafe.getItems().iterator();
        ODataCafeCustoFeedsTestCase.assertTrue((boolean)iterator2.hasNext());
        Item item = iterator2.next();
        ODataCafeCustoFeedsTestCase.assertEquals((String)"1", (String)item.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Poulet au curry", (String)item.getDescription());
        ODataCafeCustoFeedsTestCase.assertTrue((boolean)iterator2.hasNext());
        item = iterator2.next();
        ODataCafeCustoFeedsTestCase.assertEquals((String)"2", (String)item.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Pate", (String)item.getDescription());
        ODataCafeCustoFeedsTestCase.assertTrue((boolean)iterator.hasNext());
        cafe = (Cafe)iterator.next();
        ODataCafeCustoFeedsTestCase.assertEquals((String)"2", (String)cafe.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Le Petit Marly", (String)cafe.getName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Cafe inc.", (String)cafe.getCompanyName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Marly Le Roi", (String)cafe.getCity());
        ODataCafeCustoFeedsTestCase.assertEquals((int)78310, (int)cafe.getZipCode());
        iterator2 = cafe.getItems().iterator();
        ODataCafeCustoFeedsTestCase.assertTrue((boolean)iterator2.hasNext());
        item = iterator2.next();
        ODataCafeCustoFeedsTestCase.assertEquals((String)"3", (String)item.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Banana Split", (String)item.getDescription());
        ODataCafeCustoFeedsTestCase.assertTrue((boolean)iterator2.hasNext());
        item = iterator2.next();
        ODataCafeCustoFeedsTestCase.assertEquals((String)"4", (String)item.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Cotes du Rhone", (String)item.getDescription());
    }

    public void testQueryContact() {
        Query<Contact> query = this.service.createContactQuery("/Contacts('1')");
        Iterator iterator = query.iterator();
        ODataCafeCustoFeedsTestCase.assertTrue((boolean)iterator.hasNext());
        Contact contact = (Contact)iterator.next();
        ODataCafeCustoFeedsTestCase.assertNotNull((Object)contact);
        ODataCafeCustoFeedsTestCase.assertEquals((String)"1", (String)contact.getId());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Agathe Zeblues", (String)contact.getName());
        ODataCafeCustoFeedsTestCase.assertEquals((String)"Chief", (String)contact.getTitle());
    }
}

