/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.routing;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.routing.Route;
import org.restlet.test.RestletTestCase;
import org.restlet.util.RouteList;

public class RouteListTestCase
extends RestletTestCase {
    public void testGetLast() {
        RouteList list = new RouteList();
        RouteListTestCase.assertNull((Object)list.getLast(null, null, 1.0f));
        MockScoringRoute last = new MockScoringRoute(5);
        list.add((Object)new MockScoringRoute(5));
        list.add((Object)new MockScoringRoute(5));
        list.add((Object)last);
        RouteListTestCase.assertSame((Object)((Object)last), (Object)list.getLast(null, null, 1.0f));
        RouteListTestCase.assertNull((Object)list.getLast(null, null, 6.0f));
    }

    public void testGetNext() {
        RouteList list = new RouteList();
        RouteListTestCase.assertNull((Object)list.getNext(null, null, 1.0f));
        MockScoringRoute first = new MockScoringRoute(5);
        MockScoringRoute second = new MockScoringRoute(5);
        MockScoringRoute third = new MockScoringRoute(5);
        list.add((Object)first);
        list.add((Object)second);
        list.add((Object)third);
        RouteListTestCase.assertSame((Object)((Object)first), (Object)list.getNext(null, null, 1.0f));
        RouteListTestCase.assertSame((Object)((Object)second), (Object)list.getNext(null, null, 1.0f));
        RouteListTestCase.assertSame((Object)((Object)third), (Object)list.getNext(null, null, 1.0f));
        RouteListTestCase.assertSame((Object)((Object)first), (Object)list.getNext(null, null, 1.0f));
    }

    public void testGetRandom() {
        RouteList list = new RouteList();
        RouteListTestCase.assertNull((Object)list.getRandom(null, null, 1.0f));
        list.add((Object)new MockScoringRoute(2));
        list.add((Object)new MockScoringRoute(3));
        list.add((Object)new MockScoringRoute(4));
        RouteListTestCase.assertNull((Object)list.getRandom(null, null, 9.0f));
        list.add((Object)new MockScoringRoute(6));
        list.add((Object)new MockScoringRoute(7));
        list.add((Object)new MockScoringRoute(8));
        MockScoringRoute r = (MockScoringRoute)list.getRandom(null, null, 5.0f);
        RouteListTestCase.assertFalse((r == null ? 1 : 0) != 0);
        RouteListTestCase.assertTrue((r.score > 5 ? 1 : 0) != 0);
        RouteListTestCase.assertNull((Object)list.getRandom(null, null, 9.0f));
    }

    static class MockScoringRoute
    extends Route {
        int score;

        public MockScoringRoute(int score) {
            super(null);
            this.score = score;
        }

        public float score(Request request, Response response) {
            return this.score;
        }
    }
}

