/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.data;

import java.util.ArrayList;
import org.restlet.data.Form;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.test.RestletTestCase;

public class ReferenceTestCase
extends RestletTestCase {
    protected static final String DEFAULT_SCHEME = "http";
    protected static final String DEFAULT_SCHEMEPART = "//";

    protected Reference getDefaultReference() {
        Reference ref = this.getReference();
        ref.setHostDomain("www.restlet.org");
        return ref;
    }

    protected Reference getReference() {
        Reference ref = new Reference();
        ref.setScheme(DEFAULT_SCHEME);
        ref.setSchemeSpecificPart(DEFAULT_SCHEMEPART);
        return ref;
    }

    public void testAdditions() throws Exception {
        Reference ref = new Reference("http://www.restlet.org");
        ref.addQueryParameter("abc", "123");
        ReferenceTestCase.assertEquals((String)"http://www.restlet.org?abc=123", (String)ref.toString());
        ref.addQueryParameter("def", null);
        ReferenceTestCase.assertEquals((String)"http://www.restlet.org?abc=123&def", (String)ref.toString());
        ref.addSegment("root");
        ReferenceTestCase.assertEquals((String)"http://www.restlet.org/root?abc=123&def", (String)ref.toString());
        ref.addSegment("dir");
        ReferenceTestCase.assertEquals((String)"http://www.restlet.org/root/dir?abc=123&def", (String)ref.toString());
    }

    public void testEmptyRef() {
        Reference reference = new Reference();
        reference.setAuthority("testAuthority");
        reference = new Reference();
        reference.setBaseRef("http://localhost");
        reference = new Reference();
        reference.setFragment("fragment");
        reference = new Reference();
        reference.setHostDomain("localhost");
        ReferenceTestCase.assertEquals((String)"localhost", (String)reference.getAuthority());
        reference.setHostPort(new Integer(4711));
        ReferenceTestCase.assertEquals((String)"localhost:4711", (String)reference.getAuthority());
        reference.setUserInfo("sdgj:skdfj");
        ReferenceTestCase.assertEquals((String)"sdgj:skdfj@localhost:4711", (String)reference.getAuthority());
        reference = new Reference();
        reference.setIdentifier("http://host/abc/wkj");
        reference = new Reference();
        reference.setPath("loc/alhost");
        reference = new Reference();
        reference.setProtocol(Protocol.HTTPS);
        reference = new Reference();
        reference.setQuery("a=b&c=&g=1");
        reference = new Reference();
        reference.setRelativePart("http://localhost");
        reference = new Reference();
        reference.setScheme("skjf");
        reference = new Reference();
        reference.setSchemeSpecificPart("host/afjhsd");
        reference = new Reference();
        ArrayList<String> segments = new ArrayList<String>();
        segments.add("skhf");
        segments.add("sgdfg");
        segments.add("xiz");
        reference.setSegments(segments);
    }

    public void testEncoding() {
    }

    public void testEquals() throws Exception {
        Reference ref1 = this.getDefaultReference();
        Reference ref2 = this.getDefaultReference();
        ReferenceTestCase.assertEquals((Object)ref1, (Object)ref2);
        ReferenceTestCase.assertTrue((boolean)ref1.equals((Object)ref2));
    }

    public void testGetLastSegment() {
        Reference reference = new Reference("http://hostname");
        ReferenceTestCase.assertNull((Object)reference.getLastSegment());
        reference = new Reference("http://hostname/");
        ReferenceTestCase.assertNull((String)"", (Object)reference.getLastSegment());
        reference = new Reference("http://hostname/abc");
        ReferenceTestCase.assertEquals((String)"abc", (String)reference.getLastSegment());
        reference = new Reference("http://hostname/abc/");
        ReferenceTestCase.assertEquals((String)"abc", (String)reference.getLastSegment());
        reference = new Reference("http://hostname/123/abc/");
        ReferenceTestCase.assertEquals((String)"abc", (String)reference.getLastSegment());
        reference = new Reference("http://hostname/123/abc");
        ReferenceTestCase.assertEquals((String)"abc", (String)reference.getLastSegment());
    }

    public void testHostName() throws Exception {
        Reference ref = this.getReference();
        String host = "www.restlet.org";
        ref.setHostDomain(host);
        ReferenceTestCase.assertEquals((String)host, (String)ref.getHostDomain());
        host = "restlet.org";
        ref.setHostDomain(host);
        ReferenceTestCase.assertEquals((String)host, (String)ref.getHostDomain());
    }

    public void testMatrix() {
        Reference ref1 = new Reference("http://domain.tld/whatever/a=1;b=2;c=4?x=a&y=b");
        Reference ref2 = new Reference("http://domain.tld/whatever/a=1/foo;b=2;c=4;d?x=a&y=b");
        Reference ref3 = new Reference("http://domain.tld/whatever/a=1;b=2;c=4/foo?x=a&y=b");
        ReferenceTestCase.assertTrue((boolean)ref1.hasMatrix());
        ReferenceTestCase.assertTrue((boolean)ref2.hasMatrix());
        ReferenceTestCase.assertFalse((boolean)ref3.hasMatrix());
        ReferenceTestCase.assertEquals((String)"b=2;c=4", (String)ref1.getMatrix());
        ReferenceTestCase.assertEquals((String)"b=2;c=4;d", (String)ref2.getMatrix());
        Form form1 = ref1.getMatrixAsForm();
        ReferenceTestCase.assertEquals((String)"2", (String)form1.getFirstValue("b"));
        ReferenceTestCase.assertEquals((String)"4", (String)form1.getFirstValue("c"));
        Form form2 = ref1.getMatrixAsForm();
        ReferenceTestCase.assertEquals((String)"2", (String)form2.getFirstValue("b"));
        ReferenceTestCase.assertEquals((String)"4", (String)form2.getFirstValue("c"));
        ReferenceTestCase.assertNull((Object)form2.getFirstValue("d"));
        Form newForm = new Form();
        newForm.add("a", "1");
        newForm.add("b", "2");
        newForm.add("c", "4");
        ReferenceTestCase.assertEquals((String)"a=1;b=2;c=4", (String)newForm.getMatrixString());
    }

    public void testParentRef() {
        Reference baseRef = new Reference("http://test.com/foo/bar");
        Reference parentRef = baseRef.getParentRef();
        ReferenceTestCase.assertEquals((String)"http://test.com/foo/", (String)parentRef.toString());
        baseRef = new Reference("/foo/bar");
        parentRef = baseRef.getParentRef();
        ReferenceTestCase.assertEquals((String)"/foo/", (String)parentRef.toString());
    }

    public void testParsing() {
        String base = "http://a/b/c/d;p?q";
        String uri01 = "g:h";
        String uri02 = "g";
        String uri03 = "./g";
        String uri04 = "g/";
        String uri05 = "/g";
        String uri06 = "//g";
        String uri07 = "?y";
        String uri08 = "g?y";
        String uri09 = "#s";
        String uri10 = "g#s";
        String uri11 = "g?y#s";
        String uri12 = ";x";
        String uri13 = "g;x";
        String uri14 = "g;x?y#s";
        String uri15 = "";
        String uri16 = ".";
        String uri17 = "./";
        String uri18 = "..";
        String uri19 = "../";
        String uri20 = "../g";
        String uri21 = "../..";
        String uri22 = "../../";
        String uri23 = "../../g";
        String uri24 = "../../../g";
        String uri25 = "../../../../g";
        String uri26 = "/./g";
        String uri27 = "/../g";
        String uri28 = "g.";
        String uri29 = ".g";
        String uri30 = "g..";
        String uri31 = "..g";
        String uri32 = "./../g";
        String uri33 = "./g/.";
        String uri34 = "g/./h";
        String uri35 = "g/../h";
        String uri36 = "g;x=1/./y";
        String uri37 = "g;x=1/../y";
        String uri101 = "g:h";
        String uri102 = "http://a/b/c/g";
        String uri103 = "http://a/b/c/g";
        String uri104 = "http://a/b/c/g/";
        String uri105 = "http://a/g";
        String uri106 = "http://g";
        String uri107 = "http://a/b/c/d;p?y";
        String uri108 = "http://a/b/c/g?y";
        String uri109 = "http://a/b/c/d;p?q#s";
        String uri110 = "http://a/b/c/g#s";
        String uri111 = "http://a/b/c/g?y#s";
        String uri112 = "http://a/b/c/;x";
        String uri113 = "http://a/b/c/g;x";
        String uri114 = "http://a/b/c/g;x?y#s";
        String uri115 = "http://a/b/c/d;p?q";
        String uri116 = "http://a/b/c/";
        String uri117 = "http://a/b/c/";
        String uri118 = "http://a/b/";
        String uri119 = "http://a/b/";
        String uri120 = "http://a/b/g";
        String uri121 = "http://a/";
        String uri122 = "http://a/";
        String uri123 = "http://a/g";
        String uri124 = "http://a/g";
        String uri125 = "http://a/g";
        String uri126 = "http://a/g";
        String uri127 = "http://a/g";
        String uri128 = "http://a/b/c/g.";
        String uri129 = "http://a/b/c/.g";
        String uri130 = "http://a/b/c/g..";
        String uri131 = "http://a/b/c/..g";
        String uri132 = "http://a/b/g";
        String uri133 = "http://a/b/c/g/";
        String uri134 = "http://a/b/c/g/h";
        String uri135 = "http://a/b/c/h";
        String uri136 = "http://a/b/c/g;x=1/y";
        String uri137 = "http://a/b/c/y";
        Reference host = new Reference("http://host.com");
        Reference slashdir = new Reference(host, "/dir");
        Reference dir = new Reference(host, "dir");
        Reference dirslash = new Reference(host, "dir/");
        Reference fulldir = new Reference("http://host.com/dir");
        Reference fulldirsub = new Reference(fulldir, "sub");
        Reference fulldirslashsub = new Reference(fulldir, "/sub");
        Reference slashdirsub = new Reference(slashdir, "sub");
        Reference slashdirslashsub = new Reference(slashdir, "/sub");
        Reference dirslashsub = new Reference(dirslash, "sub");
        Reference fullsub = new Reference("http://host.com/dir/sub");
        this.testRef0("foo://example.com:8042/over/there?name=ferret#nose", "foo", "example.com:8042", "/over/there", "name=ferret", "nose");
        this.testRef0("urn:example:animal:ferret:nose", "urn", null, "example:animal:ferret:nose", null, null);
        this.testRef0("mailto:fred@example.com", "mailto", null, "fred@example.com", null, null);
        this.testRef0("foo://info.example.com?fred", "foo", "info.example.com", null, "fred", null);
        this.testRef0("*", null, null, "*", null, null);
        this.testRef0("http://localhost?query", DEFAULT_SCHEME, "localhost", null, "query", null);
        this.testRef0("http://localhost#?query", DEFAULT_SCHEME, "localhost", null, null, "?query");
        this.testRef0("http://localhost/?query", DEFAULT_SCHEME, "localhost", "/", "query", null);
        this.testRef0("http://localhost/#?query", DEFAULT_SCHEME, "localhost", "/", null, "?query");
        this.testRef0("http://localhost/path#frag/ment", DEFAULT_SCHEME, "localhost", "/path", null, "frag/ment");
        this.testRef0("http://localhost/path?qu/ery", DEFAULT_SCHEME, "localhost", "/path", "qu/ery", null);
        this.testRef1("http://a/b/c/d;p?q", "g:h", "g:h");
        this.testRef1("http://a/b/c/d;p?q", "g", "http://a/b/c/g");
        this.testRef1("http://a/b/c/d;p?q", "./g", "http://a/b/c/g");
        this.testRef1("http://a/b/c/d;p?q", "g/", "http://a/b/c/g/");
        this.testRef1("http://a/b/c/d;p?q", "/g", "http://a/g");
        this.testRef1("http://a/b/c/d;p?q", "//g", "http://g");
        this.testRef1("http://a/b/c/d;p?q", "?y", "http://a/b/c/d;p?y");
        this.testRef1("http://a/b/c/d;p?q", "g?y", "http://a/b/c/g?y");
        this.testRef1("http://a/b/c/d;p?q", "#s", "http://a/b/c/d;p?q#s");
        this.testRef1("http://a/b/c/d;p?q", "g#s", "http://a/b/c/g#s");
        this.testRef1("http://a/b/c/d;p?q", "g?y#s", "http://a/b/c/g?y#s");
        this.testRef1("http://a/b/c/d;p?q", ";x", "http://a/b/c/;x");
        this.testRef1("http://a/b/c/d;p?q", "g;x", "http://a/b/c/g;x");
        this.testRef1("http://a/b/c/d;p?q", "g;x?y#s", "http://a/b/c/g;x?y#s");
        this.testRef1("http://a/b/c/d;p?q", "", "http://a/b/c/d;p?q");
        this.testRef1("http://a/b/c/d;p?q", ".", "http://a/b/c/");
        this.testRef1("http://a/b/c/d;p?q", "./", "http://a/b/c/");
        this.testRef1("http://a/b/c/d;p?q", "..", "http://a/b/");
        this.testRef1("http://a/b/c/d;p?q", "../", "http://a/b/");
        this.testRef1("http://a/b/c/d;p?q", "../g", "http://a/b/g");
        this.testRef1("http://a/b/c/d;p?q", "../..", "http://a/");
        this.testRef1("http://a/b/c/d;p?q", "../../", "http://a/");
        this.testRef1("http://a/b/c/d;p?q", "../../g", "http://a/g");
        this.testRef1("http://a/b/c/d;p?q", "../../../g", "http://a/g");
        this.testRef1("http://a/b/c/d;p?q", "../../../../g", "http://a/g");
        this.testRef1("http://a/b/c/d;p?q", "/./g", "http://a/g");
        this.testRef1("http://a/b/c/d;p?q", "/../g", "http://a/g");
        this.testRef1("http://a/b/c/d;p?q", "g.", "http://a/b/c/g.");
        this.testRef1("http://a/b/c/d;p?q", ".g", "http://a/b/c/.g");
        this.testRef1("http://a/b/c/d;p?q", "g..", "http://a/b/c/g..");
        this.testRef1("http://a/b/c/d;p?q", "..g", "http://a/b/c/..g");
        this.testRef1("http://a/b/c/d;p?q", "./../g", "http://a/b/g");
        this.testRef1("http://a/b/c/d;p?q", "./g/.", "http://a/b/c/g/");
        this.testRef1("http://a/b/c/d;p?q", "g/./h", "http://a/b/c/g/h");
        this.testRef1("http://a/b/c/d;p?q", "g/../h", "http://a/b/c/h");
        this.testRef1("http://a/b/c/d;p?q", "g;x=1/./y", "http://a/b/c/g;x=1/y");
        this.testRef1("http://a/b/c/d;p?q", "g;x=1/../y", "http://a/b/c/y");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/c/g", "g");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/c/g/", "g/");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/c/d;p?y", "?y");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/c/g?y", "g?y");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/c/d;p?q#s", "#s");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/c/g#s", "g#s");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/c/g?y#s", "g?y#s");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/c/;x", ";x");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/c/g;x", "g;x");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/c/g;x?y#s", "g;x?y#s");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/c/", ".");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/", "..");
        this.testRef2("http://a/b/c/d;p?q", "http://a/b/g", "../g");
        this.testRef2("http://a/b/c/d;p?q", "http://a/", "../..");
        this.testRef2("http://a/b/c/d;p?q", "http://a/g", "../../g");
        this.testRef2("http://a/b/c/g/", "http://a/b/c/", "..");
        this.testRef2("http://a/b/c/g/", "http://a/b/", "../..");
        this.testRef3("http://localhost/path#fragment", true, true, "http://localhost/path#fragment");
        this.testRef3("http://localhost/path#fragment", true, false, "http://localhost/path");
        this.testRef3("http://localhost/path#fragment", false, true, "http://localhost/path#fragment");
        this.testRef3("http://localhost/path#fragment", false, false, "http://localhost/path");
        this.testRef3("http://localhost/path?query", true, true, "http://localhost/path?query");
        this.testRef3("http://localhost/path?query", true, false, "http://localhost/path?query");
        this.testRef3("http://localhost/path?query", false, true, "http://localhost/path");
        this.testRef3("http://localhost/path?query", false, false, "http://localhost/path");
        this.testRef3("http://localhost/path?query#fragment", true, true, "http://localhost/path?query#fragment");
        this.testRef3("http://localhost/path?query#fragment", true, false, "http://localhost/path?query");
        this.testRef3("http://localhost/path?query#fragment", false, true, "http://localhost/path#fragment");
        this.testRef3("http://localhost/path?query#fragment", false, false, "http://localhost/path");
        this.testRef3("http://localhost/path#fragment?query", true, true, "http://localhost/path#fragment?query");
        this.testRef3("http://localhost/path#fragment?query", true, false, "http://localhost/path");
        this.testRef3("http://localhost/path#fragment?query", false, true, "http://localhost/path#fragment?query");
        this.testRef3("http://localhost/path#fragment?query", false, false, "http://localhost/path");
        this.testRef4(host, DEFAULT_SCHEME, "host.com", null, "http://host.com", "http://host.com", "http://host.com", null, null);
        this.testRef4(slashdir, null, null, "/dir", null, "/dir", "http://host.com/dir", null, "/dir");
        this.testRef4(dir, null, null, "dir", null, "dir", "http://host.com/dir", null, "dir");
        this.testRef4(dirslash, null, null, "dir/", null, "dir/", "http://host.com/dir/", null, "dir/");
        this.testRef4(fulldir, DEFAULT_SCHEME, "host.com", "/dir", "http://host.com/dir", "http://host.com/dir", "http://host.com/dir", null, null);
        this.testRef4(fulldirsub, null, null, "sub", null, "sub", "http://host.com/sub", null, "sub");
        this.testRef4(fulldirslashsub, null, null, "/sub", null, "/sub", "http://host.com/sub", null, "/sub");
        this.testRef4(slashdirsub, null, null, "sub", null, "sub", "http://host.com/sub", null, "sub");
        this.testRef4(slashdirslashsub, null, null, "/sub", null, "/sub", "http://host.com/sub", null, "/sub");
        this.testRef4(dirslashsub, null, null, "sub", null, "sub", "http://host.com/dir/sub", null, "sub");
        this.testRef4(fullsub, DEFAULT_SCHEME, "host.com", "/dir/sub", "http://host.com/dir/sub", "http://host.com/dir/sub", "http://host.com/dir/sub", null, null);
    }

    public void testPort() throws Exception {
        Reference ref = this.getDefaultReference();
        int port = 8080;
        ref.setHostPort(Integer.valueOf(port));
        ReferenceTestCase.assertEquals((int)port, (int)ref.getHostPort());
        port = 9090;
        ref.setHostPort(Integer.valueOf(port));
        ReferenceTestCase.assertEquals((int)port, (int)ref.getHostPort());
    }

    public void testProtocolConstructors() {
        ReferenceTestCase.assertEquals((String)"http://restlet.org", (String)new Reference(Protocol.HTTP, "restlet.org").toString());
        ReferenceTestCase.assertEquals((String)"https://restlet.org:8443", (String)new Reference(Protocol.HTTPS, "restlet.org", 8443).toString());
        Reference ref = new Reference(Protocol.HTTP, "restlet.org");
        ref.addQueryParameter("abc", "123");
        ReferenceTestCase.assertEquals((String)"http://restlet.org?abc=123", (String)ref.toString());
    }

    public void testQuery() {
        Reference ref1 = new Reference("http://localhost/search?q=anythingelse%");
        String query = ref1.getQuery();
        ReferenceTestCase.assertEquals((String)"q=anythingelse%25", (String)query);
        Form queryForm = ref1.getQueryAsForm();
        ReferenceTestCase.assertEquals((String)"anythingelse%", (String)queryForm.getFirstValue("q"));
        Form extJsQuery = new Form("&_dc=1244741620627&callback=stcCallback1001");
        ReferenceTestCase.assertEquals((String)"1244741620627", (String)extJsQuery.getFirstValue("_dc"));
        ReferenceTestCase.assertEquals((String)"stcCallback1001", (String)extJsQuery.getFirstValue("callback"));
        Reference ref = new Reference("http://localhost/v1/projects/13404");
        ref.addQueryParameter("dyn", "true");
        ReferenceTestCase.assertEquals((String)"http://localhost/v1/projects/13404?dyn=true", (String)ref.toString());
    }

    public void testQueryWithUri() {
        Reference ref = new Reference(new Reference("http://localhost:8111/"), "http://localhost:8111/contrats/123?srvgwt=localhost:9997");
        ReferenceTestCase.assertEquals((String)"contrats/123?srvgwt=localhost:9997", (String)ref.getRelativeRef().toString());
    }

    private void testRef0(String reference, String scheme, String authority, String path, String query, String fragment) {
        Reference ref = new Reference(reference);
        ReferenceTestCase.assertEquals((String)scheme, (String)ref.getScheme());
        ReferenceTestCase.assertEquals((String)authority, (String)ref.getAuthority());
        ReferenceTestCase.assertEquals((String)path, (String)ref.getPath());
        ReferenceTestCase.assertEquals((String)query, (String)ref.getQuery());
        ReferenceTestCase.assertEquals((String)fragment, (String)ref.getFragment());
    }

    private void testRef1(String baseUri, String relativeUri, String expectedAbsoluteUri) {
        Reference baseRef = new Reference(baseUri);
        Reference relativeRef = new Reference(baseRef, relativeUri);
        Reference absoluteRef = relativeRef.getTargetRef();
        ReferenceTestCase.assertEquals((String)expectedAbsoluteUri, (String)absoluteRef.toString());
    }

    private void testRef2(String baseUri, String absoluteUri, String expectedRelativeUri) {
        Reference baseRef = new Reference(baseUri);
        Reference absoluteRef = new Reference(absoluteUri);
        Reference relativeRef = absoluteRef.getRelativeRef(baseRef);
        ReferenceTestCase.assertEquals((String)expectedRelativeUri, (String)relativeRef.toString());
    }

    private void testRef3(String reference, boolean query, boolean fragment, String toString) {
        Reference ref = new Reference(reference);
        ReferenceTestCase.assertEquals((String)ref.toString(query, fragment), (String)toString);
    }

    private void testRef4(Reference reference, String scheme, String authority, String path, String remainingPart, String toString, String targetRef, String query, String relativePart) {
        ReferenceTestCase.assertEquals((String)reference.getScheme(), (String)scheme);
        ReferenceTestCase.assertEquals((String)reference.getAuthority(), (String)authority);
        ReferenceTestCase.assertEquals((String)reference.getPath(), (String)path);
        ReferenceTestCase.assertEquals((String)reference.getRemainingPart(), (String)remainingPart);
        ReferenceTestCase.assertEquals((String)reference.toString(), (String)toString);
        ReferenceTestCase.assertEquals((String)reference.getTargetRef().toString(), (String)targetRef);
        ReferenceTestCase.assertEquals((String)reference.getQuery(), (String)query);
        ReferenceTestCase.assertEquals((String)reference.getRelativePart(), (String)relativePart);
    }

    public void testRiap() throws Exception {
        Reference baseRef = new Reference("riap://component/exist/db/");
        Reference ref = new Reference(baseRef, "something.xq");
        ReferenceTestCase.assertEquals((String)"riap://component/exist/db/something.xq", (String)ref.getTargetRef().toString());
    }

    public void testScheme() throws Exception {
        Reference ref = this.getDefaultReference();
        ReferenceTestCase.assertEquals((String)DEFAULT_SCHEME, (String)ref.getScheme());
        String scheme = "https";
        ref.setScheme("https");
        ReferenceTestCase.assertEquals((String)"https", (String)ref.getScheme());
        ref.setScheme(DEFAULT_SCHEME);
        ReferenceTestCase.assertEquals((String)DEFAULT_SCHEME, (String)ref.getScheme());
    }

    public void testSchemeSpecificPart() throws Exception {
        Reference ref = this.getDefaultReference();
        String part = "//www.restlet.org";
        ReferenceTestCase.assertEquals((String)part, (String)ref.getSchemeSpecificPart());
        part = "//www.restlet.net";
        ref.setSchemeSpecificPart(part);
        ReferenceTestCase.assertEquals((String)part, (String)ref.getSchemeSpecificPart());
    }

    public void testSetLastSegment() {
        Reference ref = new Reference("http://localhost:1234");
        ref.addSegment("test");
        ReferenceTestCase.assertEquals((String)"http://localhost:1234/test", (String)ref.toString());
        ref.setLastSegment("last");
        ReferenceTestCase.assertEquals((String)"http://localhost:1234/last", (String)ref.toString());
        ref = new Reference("http://localhost:1234");
        ref.setLastSegment("last");
        ReferenceTestCase.assertEquals((String)"http://localhost:1234/last", (String)ref.toString());
        ref.setLastSegment("test");
        ReferenceTestCase.assertEquals((String)"http://localhost:1234/test", (String)ref.toString());
        ref.addSegment("last");
        ReferenceTestCase.assertEquals((String)"http://localhost:1234/test/last", (String)ref.toString());
    }

    public void testUnEquals() throws Exception {
        String uri1 = "http://www.restlet.org/";
        String uri2 = "http://www.restlet.net/";
        Reference ref1 = new Reference("http://www.restlet.org/");
        Reference ref2 = new Reference("http://www.restlet.net/");
        ReferenceTestCase.assertFalse((boolean)ref1.equals((Object)ref2));
        ReferenceTestCase.assertFalse((boolean)ref1.equals(null));
    }

    public void testUserinfo() {
        Reference reference = new Reference("http://localhost:81");
        reference.setUserInfo("login:password");
        ReferenceTestCase.assertEquals((String)"login:password@localhost:81", (String)reference.getAuthority());
        ReferenceTestCase.assertEquals((String)"localhost", (String)reference.getHostDomain());
        ReferenceTestCase.assertEquals((int)81, (int)reference.getHostPort());
        ReferenceTestCase.assertEquals((String)"login:password", (String)reference.getUserInfo());
        reference.setHostDomain("www.example.com");
        ReferenceTestCase.assertEquals((String)"login:password@www.example.com:81", (String)reference.getAuthority());
        ReferenceTestCase.assertEquals((String)"www.example.com", (String)reference.getHostDomain());
        ReferenceTestCase.assertEquals((int)81, (int)reference.getHostPort());
        ReferenceTestCase.assertEquals((String)"login:password", (String)reference.getUserInfo());
        reference.setHostPort(Integer.valueOf(82));
        ReferenceTestCase.assertEquals((String)"login:password@www.example.com:82", (String)reference.getAuthority());
        ReferenceTestCase.assertEquals((String)"www.example.com", (String)reference.getHostDomain());
        ReferenceTestCase.assertEquals((int)82, (int)reference.getHostPort());
        ReferenceTestCase.assertEquals((String)"login:password", (String)reference.getUserInfo());
        reference.setUserInfo("login");
        ReferenceTestCase.assertEquals((String)"login@www.example.com:82", (String)reference.getAuthority());
        ReferenceTestCase.assertEquals((String)"www.example.com", (String)reference.getHostDomain());
        ReferenceTestCase.assertEquals((int)82, (int)reference.getHostPort());
        ReferenceTestCase.assertEquals((String)"login", (String)reference.getUserInfo());
    }

    public void testValidity() {
        String uri = "http ://domain.tld/whatever/";
        Reference ref = new Reference(uri);
        ReferenceTestCase.assertEquals((String)"http%20://domain.tld/whatever/", (String)ref.toString());
        uri = "file:///C|/wherever\\whatever.swf";
        ref = new Reference(uri);
        ReferenceTestCase.assertEquals((String)"file:///C%7C/wherever%5Cwhatever.swf", (String)ref.toString());
    }
}

