/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.data;

import org.restlet.data.Status;
import org.restlet.test.RestletTestCase;

public class StatusTestCase
extends RestletTestCase {
    public void testCustomDescription() {
        String customDescription = "My custom description";
        Status s = new Status(Status.CLIENT_ERROR_NOT_FOUND, "My custom description");
        StatusTestCase.assertEquals((String)"My custom description", (String)s.getDescription());
    }

    public void testEquals() throws Exception {
        Status s1 = new Status(201);
        Status s2 = Status.SUCCESS_CREATED;
        StatusTestCase.assertTrue((boolean)s1.equals((Object)s2));
        StatusTestCase.assertTrue((s1.getCode() == s2.getCode() ? 1 : 0) != 0);
        StatusTestCase.assertEquals((Object)s1, (Object)s2);
        StatusTestCase.assertTrue((boolean)s1.equals((Object)s1));
        StatusTestCase.assertEquals((Object)s1, (Object)s1);
    }

    public void testStatusClasses() {
        Status s1 = new Status(287);
        StatusTestCase.assertTrue((boolean)s1.isSuccess());
        Status s2 = Status.CLIENT_ERROR_BAD_REQUEST;
        StatusTestCase.assertTrue((boolean)s2.isClientError());
        StatusTestCase.assertTrue((boolean)s2.isError());
    }

    public void testUnEquals() throws Exception {
        Status s1 = new Status(200);
        Status s2 = Status.SUCCESS_CREATED;
        StatusTestCase.assertFalse((boolean)s1.equals((Object)s2));
        StatusTestCase.assertFalse((s1.getCode() == s2.getCode() ? 1 : 0) != 0);
        StatusTestCase.assertFalse((boolean)s1.equals(null));
        StatusTestCase.assertFalse((boolean)s2.equals(null));
    }
}

