/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.resources;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.restlet.data.Form;
import org.restlet.engine.io.IoUtils;
import org.restlet.ext.jaxrs.internal.core.MultivaluedMapImpl;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.test.jaxrs.services.others.Person;
import org.restlet.test.jaxrs.util.TestUtils;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/providerTest")
public class ProviderTestService {
    public static final String STRING2 = "Rom\u00e4n";
    public static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int CS_LAST_CHAR = 126;

    public static String createCS() {
        StringBuilder stb = new StringBuilder();
        for (char c = ' '; c <= '~'; c = (char)(c + '\u0001')) {
            stb.append(c);
        }
        return stb.toString();
    }

    @GET
    @Path(value="BufferedReader")
    @Produces(value={"application/octet-stream"})
    public BufferedReader bufferedReaderGet() {
        return new BufferedReader(this.readerGet(), IoUtils.BUFFER_SIZE);
    }

    @POST
    @Path(value="BufferedReader")
    @Produces(value={"text/plain"})
    public String bufferedReaderPost(BufferedReader reader) throws IOException {
        String line;
        StringBuilder stb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            stb.append(line);
            stb.append('\n');
        }
        stb.deleteCharAt(stb.length() - 1);
        return stb.toString();
    }

    @GET
    @Path(value="byteArray")
    @Produces(value={"application/octet-stream"})
    public byte[] byteArrayGet() {
        return ALPHABET.getBytes();
    }

    @POST
    @Path(value="byteArray")
    @Produces(value={"text/plain"})
    public String byteArrayPost(byte[] byteArray) {
        return new String(byteArray);
    }

    @GET
    @Path(value="CharSequence")
    @Produces(value={"text/plain"})
    public CharSequence charSequenceGet() {
        return new CharSequence(){

            public char charAt(int index) {
                return (char)(index + 32);
            }

            public int length() {
                return 95;
            }

            public CharSequence subSequence(int start, int end) {
                return this.toString().subSequence(start, end);
            }

            public String toString() {
                return ProviderTestService.createCS();
            }
        };
    }

    @POST
    @Path(value="CharSequence")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public String charSequencePost(CharSequence form) {
        return ((Object)form).toString();
    }

    @GET
    @Path(value="file")
    @Produces(value={"application/octet-stream"})
    public File fileGet() {
        return new File(this.getClass().getResource("alphabet.txt").getPath());
    }

    @POST
    @Path(value="file")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"text/plain"})
    public String filePost(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        return this.inputStreamPost(inputStream);
    }

    @GET
    @Path(value="form")
    @Produces(value={"application/x-www-form-urlencoded"})
    public Form formGet() {
        Form form = new Form();
        form.add("firstname", "Angela");
        form.add("lastname", "Merkel");
        return form;
    }

    @POST
    @Path(value="form")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String formPost(Form form) {
        return form.toString();
    }

    @GET
    @Path(value="InputStream")
    @Produces(value={"application/octet-stream"})
    public InputStream inputStreamGet() {
        return new ByteArrayInputStream(ALPHABET.getBytes());
    }

    @POST
    @Path(value="InputStream")
    @Produces(value={"text/plain"})
    public String inputStreamPost(InputStream inputStream) throws IOException {
        int b;
        StringBuilder stb = new StringBuilder();
        while ((b = inputStream.read()) >= 0) {
            stb.append((char)b);
        }
        return stb.toString();
    }

    @GET
    @Path(value="jaxbElement")
    @Produces(value={"text/xml"})
    public JAXBElement<Person> jaxbElementGet() {
        return new JAXBElement(new QName("qName"), Person.class, (Object)this.jaxbGet());
    }

    @GET
    @Path(value="jaxb")
    @Produces(value={"text/xml"})
    public Person jaxbGet() {
        return new Person("Angela", "Merkel");
    }

    @POST
    @Path(value="jaxbElement")
    @Consumes(value={"text/xml", "application/xml"})
    @Produces(value={"text/plain"})
    public String jaxbPost(JAXBElement<Person> person) {
        if (person == null) {
            throw new WebApplicationException(Response.serverError().entity((Object)"the JAXBElement is null").build());
        }
        if (person.getValue() == null) {
            return null;
        }
        return ((Person)person.getValue()).toString();
    }

    @POST
    @Path(value="jaxbElement/rootElement")
    @Consumes(value={"text/xml", "application/xml"})
    @Produces(value={"text/plain"})
    public String jaxbPostRootElement(JAXBElement<Person> person) {
        if (person == null) {
            throw new WebApplicationException(Response.serverError().entity((Object)"the JAXBElement is null").build());
        }
        if (person.getValue() == null) {
            return null;
        }
        return person.getName().toString();
    }

    @POST
    @Path(value="jaxb")
    @Consumes(value={"text/xml", "application/xml"})
    @Produces(value={"text/plain"})
    public String jaxbPost(Person person) {
        return person.toString();
    }

    @GET
    @Path(value="MultivaluedMap")
    @Produces(value={"application/x-www-form-urlencoded"})
    public MultivaluedMap<String, String> mMapGet() {
        MultivaluedMapImpl mmap = new MultivaluedMapImpl();
        mmap.add((Object)"firstname", (Object)"Angela");
        mmap.add((Object)"lastname", (Object)"Merkel");
        return mmap;
    }

    @POST
    @Path(value="MultivaluedMap")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public String mMapPost(MultivaluedMap<String, String> mmap) {
        return Converter.toForm(mmap).toString();
    }

    @POST
    @Path(value="multipart/form-data")
    @Consumes(value={"multipart/form-data"})
    public Object multipartPost(@QueryParam(value="attrNo") int attrNo, Multipart multipart) throws MessagingException, IOException {
        BodyPart bodyPart = multipart.getBodyPart(attrNo);
        return bodyPart.getInputStream();
    }

    @GET
    @Path(value="Reader")
    @Produces(value={"application/octet-stream"})
    public Reader readerGet() {
        return new StringReader(ALPHABET);
    }

    @POST
    @Path(value="Reader")
    @Produces(value={"text/plain"})
    public String readerPost(Reader reader) throws IOException {
        int c;
        StringBuilder stb = new StringBuilder();
        while ((c = reader.read()) >= 0) {
            stb.append((char)c);
        }
        return stb.toString();
    }

    @GET
    @Path(value="StringBuilder")
    @Produces(value={"text/plain"})
    public StringBuilder stringBuilderGet() {
        return new StringBuilder(ALPHABET);
    }

    @GET
    @Path(value="String")
    @Produces(value={"text/plain"})
    public String stringGet() {
        return ALPHABET;
    }

    @GET
    @Path(value="String2")
    @Produces(value={"text/plain"})
    public String string2Get() {
        return STRING2;
    }

    @POST
    @Path(value="String")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public String stringPost(String entity) {
        return entity;
    }

    @GET
    @Path(value="String/substring")
    @Produces(value={"text/plain"})
    public String subStringGet(@MatrixParam(value="start") int start, @MatrixParam(value="end") int end) {
        if (end >= ALPHABET.length()) {
            return ALPHABET.substring(start);
        }
        return ALPHABET.substring(start, end);
    }

    @GET
    @Path(value="source")
    @Produces(value={"text/xml"})
    public Source xsltGet() {
        return new StreamSource(new ByteArrayInputStream("<abc/>".getBytes()));
    }

    @POST
    @Path(value="source")
    @Consumes(value={"text/xml"})
    @Produces(value={"text/plain"})
    public byte[] xsltPost(Source source) throws IOException {
        InputSource inputSource = SAXSource.sourceToInputSource(source);
        return TestUtils.getByteArray(inputSource.getByteStream());
    }
}

