/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.restlet.Uniform;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.RepresentationInfo;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.UniformResource;
import org.restlet.service.ConverterService;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerResource
extends UniformResource {
    private volatile boolean annotated = true;
    private volatile boolean conditional = true;
    private volatile boolean existing = true;
    private volatile boolean negotiated = true;
    private volatile List<Variant> variants = null;

    protected Representation delete() throws ResourceException {
        Representation result = null;
        AnnotationInfo annotationInfo = this.getAnnotation(Method.DELETE);
        if (annotationInfo != null) {
            result = this.doHandle(annotationInfo);
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation delete(Variant variant) throws ResourceException {
        Representation result = null;
        if (variant instanceof VariantInfo) {
            result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation describeVariants() {
        Representation result = null;
        return result;
    }

    protected Representation doConditionalHandle() throws ResourceException {
        Representation result = null;
        if (this.getConditions().hasSome()) {
            if (!this.isExisting() && this.getConditions().getMatch().contains(Tag.ALL)) {
                this.setStatus(Status.CLIENT_ERROR_PRECONDITION_FAILED, "A non existing resource can't match any tag.");
            } else {
                RepresentationInfo resultInfo = null;
                resultInfo = this.isNegotiated() ? this.doGetInfo(this.getPreferredVariant(this.getVariants())) : this.doGetInfo();
                if (resultInfo == null) {
                    if (this.getStatus() == null || this.getStatus().isSuccess() && !Status.SUCCESS_NO_CONTENT.equals(this.getStatus())) {
                        this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                    }
                } else {
                    Status status = this.getConditions().getStatus(this.getMethod(), resultInfo);
                    if (status != null) {
                        this.setStatus(status);
                    }
                }
                if (this.getStatus() != null && this.getStatus().isSuccess()) {
                    result = (Method.GET.equals(this.getMethod()) || Method.HEAD.equals(this.getMethod())) && resultInfo instanceof Representation ? (Representation)resultInfo : (this.isNegotiated() ? this.doNegotiatedHandle() : this.doHandle());
                }
            }
        } else {
            result = this.isNegotiated() ? this.doNegotiatedHandle() : this.doHandle();
        }
        return result;
    }

    private RepresentationInfo doGetInfo() throws ResourceException {
        RepresentationInfo result = null;
        AnnotationInfo annotationInfo = this.getAnnotation(Method.GET);
        result = annotationInfo != null ? this.doHandle(annotationInfo) : this.getInfo();
        return result;
    }

    private RepresentationInfo doGetInfo(Variant variant) throws ResourceException {
        RepresentationInfo result = null;
        result = variant != null ? (variant instanceof VariantInfo ? this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant) : (variant instanceof RepresentationInfo ? (RepresentationInfo)variant : this.getInfo(variant))) : this.doGetInfo();
        return result;
    }

    protected Representation doHandle() throws ResourceException {
        Representation result = null;
        Method method = this.getMethod();
        if (method == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "No method specified");
        } else if (method.equals(Method.PUT)) {
            result = this.put(this.getRequestEntity());
        } else if (this.isExisting()) {
            if (method.equals(Method.GET)) {
                result = this.get();
            } else if (method.equals(Method.POST)) {
                result = this.post(this.getRequestEntity());
            } else if (method.equals(Method.DELETE)) {
                result = this.delete();
            } else if (method.equals(Method.HEAD)) {
                result = this.head();
            } else if (method.equals(Method.OPTIONS)) {
                result = this.options();
            } else {
                AnnotationInfo annotationInfo = this.getAnnotation(method);
                if (annotationInfo != null) {
                    result = this.doHandle(annotationInfo);
                } else {
                    this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                }
            }
        } else {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return result;
    }

    private Representation doHandle(AnnotationInfo annotationInfo) throws ResourceException {
        Representation result = null;
        ConverterService cs = this.getConverterService();
        Class<?>[] parameterTypes = annotationInfo.getJavaInputTypes();
        ArrayList parameters = null;
        Object resultObject = null;
        try {
            if (parameterTypes.length > 0) {
                parameters = new ArrayList();
                for (Class<?> parameterType : parameterTypes) {
                    if (this.getRequestEntity() != null) {
                        try {
                            parameters.add(cs.toObject(this.getRequestEntity(), parameterType, this));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            parameters.add(null);
                        }
                        continue;
                    }
                    parameters.add(null);
                }
                resultObject = annotationInfo.getJavaMethod().invoke((Object)this, parameters.toArray());
            } else {
                resultObject = annotationInfo.getJavaMethod().invoke((Object)this, new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ResourceException(e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ResourceException) {
                throw (ResourceException)e.getTargetException();
            }
            throw new ResourceException(e.getTargetException());
        }
        if (resultObject != null) {
            result = cs.toRepresentation(resultObject);
        }
        return result;
    }

    private Representation doHandle(AnnotationInfo annotationInfo, Variant variant) throws ResourceException {
        Representation result = null;
        ConverterService cs = this.getConverterService();
        Object resultObject = null;
        try {
            if (annotationInfo.getJavaInputTypes() != null && annotationInfo.getJavaInputTypes().length > 0) {
                ArrayList<Variant> parameters = new ArrayList<Variant>();
                Object parameter = null;
                for (Class<?> param : annotationInfo.getJavaInputTypes()) {
                    if (Variant.class.equals(param)) {
                        parameters.add(variant);
                        continue;
                    }
                    if (this.getRequestEntity().isAvailable()) {
                        try {
                            parameter = cs.toObject(this.getRequestEntity(), param, this);
                        }
                        catch (IOException e) {
                            parameter = null;
                        }
                        if (parameter == null) {
                            throw new ResourceException(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE);
                        }
                    } else {
                        parameter = null;
                    }
                    parameters.add((Variant)parameter);
                }
                resultObject = annotationInfo.getJavaMethod().invoke((Object)this, parameters.toArray());
            } else {
                resultObject = annotationInfo.getJavaMethod().invoke((Object)this, new Object[0]);
            }
            result = cs.toRepresentation(resultObject, variant, this);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceException(e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ResourceException) {
                throw (ResourceException)e.getTargetException();
            }
            throw new ResourceException(e.getTargetException());
        }
        return result;
    }

    protected Representation doHandle(Variant variant) throws ResourceException {
        Representation result = null;
        Method method = this.getMethod();
        if (method == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "No method specified");
        } else if (method.equals(Method.PUT)) {
            result = this.put(this.getRequestEntity(), variant);
        } else if (this.isExisting()) {
            if (method.equals(Method.GET)) {
                result = variant instanceof Representation ? (Representation)variant : this.get(variant);
            } else if (method.equals(Method.POST)) {
                result = this.post(this.getRequestEntity(), variant);
            } else if (method.equals(Method.DELETE)) {
                result = this.delete(variant);
            } else if (method.equals(Method.HEAD)) {
                result = variant instanceof Representation ? (Representation)variant : this.head(variant);
            } else if (method.equals(Method.OPTIONS)) {
                result = variant instanceof Representation ? (Representation)variant : this.options(variant);
            } else if (variant instanceof VariantInfo) {
                result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
            } else {
                this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
        } else {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return result;
    }

    protected Representation doNegotiatedHandle() throws ResourceException {
        Representation result = null;
        if (this.getVariants() != null && !this.getVariants().isEmpty()) {
            Variant preferredVariant = this.getClientInfo().getPreferredVariant(this.getVariants(), this.getMetadataService());
            if (preferredVariant == null) {
                this.setStatus(Status.CLIENT_ERROR_NOT_ACCEPTABLE);
                result = this.describeVariants();
            } else {
                this.updateDimensions();
                result = this.doHandle(preferredVariant);
            }
        } else {
            result = this.doHandle();
        }
        return result;
    }

    protected Representation get() throws ResourceException {
        Representation result = null;
        AnnotationInfo annotationInfo = this.getAnnotation(Method.GET);
        if (annotationInfo != null) {
            result = this.doHandle(annotationInfo);
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation get(Variant variant) throws ResourceException {
        Representation result = null;
        if (variant instanceof VariantInfo) {
            result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    private AnnotationInfo getAnnotation(Method method) {
        if (this.isAnnotated()) {
            return AnnotationUtils.getAnnotation(this.getAnnotations(), method);
        }
        return null;
    }

    private List<AnnotationInfo> getAnnotations() {
        return this.isAnnotated() ? AnnotationUtils.getAnnotationDescriptors(this.getClass()) : null;
    }

    protected RepresentationInfo getInfo() throws ResourceException {
        return this.get();
    }

    protected RepresentationInfo getInfo(Variant variant) throws ResourceException {
        return this.get(variant);
    }

    public Uniform getOnContinue() {
        return this.getResponse().getOnContinue();
    }

    public Uniform getOnSent() {
        return this.getResponse().getOnSent();
    }

    protected Variant getPreferredVariant(List<Variant> variants) {
        Variant result = null;
        if (variants != null && !variants.isEmpty()) {
            result = this.getClientInfo().getPreferredVariant(variants, this.getApplication() == null ? null : this.getApplication().getMetadataService());
        }
        return result;
    }

    public List<Variant> getVariants() {
        List<Variant> result = this.variants;
        if (result == null) {
            result = new ArrayList<Variant>();
            if (this.isAnnotated() && this.hasAnnotations()) {
                List<Variant> annoVariants = null;
                for (AnnotationInfo annotationInfo : this.getAnnotations()) {
                    if (!this.getMethod().equals(annotationInfo.getRestletMethod()) || (annoVariants = annotationInfo.getResponseVariants(this.getRequestEntity(), this.getMetadataService(), this.getConverterService())) == null) continue;
                    for (Variant v : annoVariants) {
                        result.add(new VariantInfo(v, annotationInfo));
                    }
                }
            }
            this.variants = result;
        }
        return result;
    }

    @Override
    public Representation handle() {
        Representation result = null;
        if (!this.isExisting() && this.getMethod().isSafe()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        } else {
            try {
                result = this.isConditional() ? this.doConditionalHandle() : (this.isNegotiated() ? this.doNegotiatedHandle() : this.doHandle());
                this.getResponse().setEntity(result);
                if (Status.CLIENT_ERROR_METHOD_NOT_ALLOWED.equals(this.getStatus())) {
                    this.updateAllowedMethods();
                }
            }
            catch (Throwable t) {
                this.doCatch(t);
            }
        }
        return result;
    }

    private boolean hasAnnotations() {
        return this.getAnnotations() != null && !this.getAnnotations().isEmpty();
    }

    protected Representation head() throws ResourceException {
        return this.get();
    }

    protected Representation head(Variant variant) throws ResourceException {
        return this.get(variant);
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public boolean isExisting() {
        return this.existing;
    }

    public boolean isInRole(String roleName) {
        return this.getClientInfo().getRoles().contains(this.getApplication().findRole(roleName));
    }

    public boolean isNegotiated() {
        return this.negotiated;
    }

    protected Representation options() throws ResourceException {
        Representation result = null;
        AnnotationInfo annotationInfo = this.getAnnotation(Method.OPTIONS);
        if (annotationInfo != null) {
            result = this.doHandle(annotationInfo);
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation options(Variant variant) throws ResourceException {
        Representation result = null;
        if (variant instanceof VariantInfo) {
            result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation post(Representation entity) throws ResourceException {
        Representation result = null;
        AnnotationInfo annotationInfo = this.getAnnotation(Method.POST);
        if (annotationInfo != null) {
            result = this.doHandle(annotationInfo);
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation post(Representation entity, Variant variant) throws ResourceException {
        Representation result = null;
        if (variant instanceof VariantInfo) {
            result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation put(Representation representation) throws ResourceException {
        Representation result = null;
        AnnotationInfo annotationInfo = this.getAnnotation(Method.PUT);
        if (annotationInfo != null) {
            result = this.doHandle(annotationInfo);
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation put(Representation representation, Variant variant) throws ResourceException {
        Representation result = null;
        if (variant instanceof VariantInfo) {
            result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    public void redirectPermanent(Reference targetRef) {
        if (this.getResponse() != null) {
            this.getResponse().redirectPermanent(targetRef);
        }
    }

    public void redirectPermanent(String targetUri) {
        if (this.getResponse() != null) {
            this.getResponse().redirectPermanent(targetUri);
        }
    }

    public void redirectSeeOther(Reference targetRef) {
        if (this.getResponse() != null) {
            this.getResponse().redirectSeeOther(targetRef);
        }
    }

    public void redirectSeeOther(String targetUri) {
        if (this.getResponse() != null) {
            this.getResponse().redirectSeeOther(targetUri);
        }
    }

    public void redirectTemporary(Reference targetRef) {
        if (this.getResponse() != null) {
            this.getResponse().redirectTemporary(targetRef);
        }
    }

    public void redirectTemporary(String targetUri) {
        if (this.getResponse() != null) {
            this.getResponse().redirectTemporary(targetUri);
        }
    }

    public void setAllowedMethods(Set<Method> allowedMethods) {
        if (this.getResponse() != null) {
            this.getResponse().setAllowedMethods(allowedMethods);
        }
    }

    public void setAnnotated(boolean annotated) {
        this.annotated = annotated;
    }

    public void setChallengeRequests(List<ChallengeRequest> requests) {
        if (this.getResponse() != null) {
            this.getResponse().setChallengeRequests(requests);
        }
    }

    public void setConditional(boolean conditional) {
        this.conditional = conditional;
    }

    public void setCookieSettings(Series<CookieSetting> cookieSettings) {
        if (this.getResponse() != null) {
            this.getResponse().setCookieSettings(cookieSettings);
        }
    }

    public void setDimensions(Set<Dimension> dimensions) {
        if (this.getResponse() != null) {
            this.getResponse().setDimensions(dimensions);
        }
    }

    public void setExisting(boolean exists) {
        this.existing = exists;
    }

    public void setLocationRef(Reference locationRef) {
        if (this.getResponse() != null) {
            this.getResponse().setLocationRef(locationRef);
        }
    }

    public void setLocationRef(String locationUri) {
        if (this.getResponse() != null) {
            this.getResponse().setLocationRef(locationUri);
        }
    }

    public void setNegotiated(boolean negotiateContent) {
        this.negotiated = negotiateContent;
    }

    public void setOnContinue(Uniform onContinueCallback) {
        this.getResponse().setOnContinue(onContinueCallback);
    }

    public void setOnSent(Uniform onSentCallback) {
        this.getResponse().setOnSent(onSentCallback);
    }

    public void setServerInfo(ServerInfo serverInfo) {
        if (this.getResponse() != null) {
            this.getResponse().setServerInfo(serverInfo);
        }
    }

    public void setStatus(Status status) {
        if (this.getResponse() != null) {
            this.getResponse().setStatus(status);
        }
    }

    public void setStatus(Status status, String message) {
        if (this.getResponse() != null) {
            this.getResponse().setStatus(status, message);
        }
    }

    public void setStatus(Status status, Throwable throwable) {
        if (this.getResponse() != null) {
            this.getResponse().setStatus(status, throwable);
        }
    }

    public void setStatus(Status status, Throwable throwable, String message) {
        if (this.getResponse() != null) {
            this.getResponse().setStatus(status, throwable, message);
        }
    }

    protected void updateAllowedMethods() {
    }

    protected void updateDimensions() {
        this.getDimensions().add(Dimension.CHARACTER_SET);
        this.getDimensions().add(Dimension.ENCODING);
        this.getDimensions().add(Dimension.LANGUAGE);
        this.getDimensions().add(Dimension.MEDIA_TYPE);
    }
}

