/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.security;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.engine.http.header.ChallengeWriter;
import org.restlet.engine.http.header.HeaderReader;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.util.Base64;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpBasicHelper
extends AuthenticatorHelper {
    public HttpBasicHelper() {
        super(ChallengeScheme.HTTP_BASIC, true, true);
    }

    @Override
    public void formatRawRequest(ChallengeWriter cw, ChallengeRequest challenge, Response response, Series<Parameter> httpHeaders) throws IOException {
        if (challenge.getRealm() != null) {
            cw.appendQuotedChallengeParameter("realm", challenge.getRealm());
        }
    }

    @Override
    public void formatRawResponse(ChallengeWriter cw, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        try {
            if (challenge == null) {
                throw new RuntimeException("No challenge provided, unable to encode credentials");
            }
            CharArrayWriter credentials = new CharArrayWriter();
            credentials.write(challenge.getIdentifier());
            credentials.write(":");
            credentials.write(challenge.getSecret());
            cw.append(Base64.encode(credentials.toCharArray(), "ISO-8859-1", false));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding, unable to encode credentials");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception, unable to encode credentials", e);
        }
    }

    @Override
    public void parseRequest(ChallengeRequest challenge, Response response, Series<Parameter> httpHeaders) {
        if (challenge.getRawValue() != null) {
            HeaderReader hr = new HeaderReader(challenge.getRawValue());
            try {
                Parameter param = hr.readParameter();
                while (param != null) {
                    try {
                        if ("realm".equals(param.getName())) {
                            challenge.setRealm(param.getValue());
                        } else {
                            challenge.getParameters().add(param);
                        }
                        if (hr.skipValueSeparator()) {
                            param = hr.readParameter();
                            continue;
                        }
                        param = null;
                    }
                    catch (Exception e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
                    }
                }
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
            }
        }
    }

    @Override
    public void parseResponse(ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        try {
            String credentials;
            int separator;
            byte[] credentialsEncoded = Base64.decode(challenge.getRawValue());
            if (credentialsEncoded == null) {
                this.getLogger().info("Cannot decode credentials: " + challenge.getRawValue());
            }
            if ((separator = (credentials = new String(credentialsEncoded, "ISO-8859-1")).indexOf(58)) == -1) {
                this.getLogger().info("Invalid credentials given by client with IP: " + (request != null ? request.getClientInfo().getAddress() : "?"));
            } else {
                challenge.setIdentifier(credentials.substring(0, separator));
                challenge.setSecret(credentials.substring(separator + 1));
            }
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().log(Level.INFO, "Unsupported HTTP Basic encoding error", e);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().log(Level.INFO, "Unable to decode the HTTP Basic credential", e);
        }
    }
}

