/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.util.logging.LogManager;
import org.restlet.Context;
import org.restlet.data.Reference;
import org.restlet.engine.log.LogFilter;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.routing.Filter;
import org.restlet.service.Service;

public class LogService
extends Service {
    private volatile String loggerName = null;
    private volatile String logFormat = null;
    private volatile Reference logPropertiesRef = null;
    private volatile boolean identityCheck = false;

    public LogService() {
        this(true);
    }

    public LogService(boolean enabled) {
        super(enabled);
    }

    public Filter createInboundFilter(Context context) {
        return new LogFilter(context, this);
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public Reference getLogPropertiesRef() {
        return this.logPropertiesRef;
    }

    public boolean isIdentityCheck() {
        return this.identityCheck;
    }

    public void setIdentityCheck(boolean identityCheck) {
        this.identityCheck = identityCheck;
    }

    public void setLogFormat(String format) {
        this.logFormat = format;
    }

    public void setLoggerName(String name) {
        this.loggerName = name;
    }

    public void setLogPropertiesRef(Reference logPropertiesRef) {
        this.logPropertiesRef = logPropertiesRef;
    }

    public void setLogPropertiesRef(String logPropertiesUri) {
        this.setLogPropertiesRef(new Reference(logPropertiesUri));
    }

    public synchronized void start() throws Exception {
        Representation logProperties;
        super.start();
        if (this.getLogPropertiesRef() != null && (logProperties = new ClientResource(this.getContext(), this.getLogPropertiesRef()).get()) != null) {
            LogManager.getLogManager().readConfiguration(logProperties.getStream());
        }
    }
}

