/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.security.Principal;
import org.restlet.Response;
import org.restlet.data.ChallengeMessage;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChallengeResponse
extends ChallengeMessage {
    private volatile boolean authenticated;
    private volatile String clientNonce;
    private volatile Reference digestRef;
    private volatile String identifier;
    private volatile String quality;
    private volatile char[] secret;
    private volatile int serverNounceCount;

    public ChallengeResponse(ChallengeRequest challengeRequest, Response response, String identifier, char[] baseSecret) {
        this(challengeRequest, response, identifier, baseSecret, "NONE");
    }

    public ChallengeResponse(ChallengeRequest challengeRequest, Response response, String identifier, String baseSecret) {
        this(challengeRequest, response, identifier, baseSecret.toCharArray(), "NONE");
    }

    public ChallengeResponse(ChallengeRequest challengeRequest, Response response, String identifier, char[] baseSecret, String baseSecretAlgorithm) {
        super(challengeRequest.getScheme());
        this.identifier = identifier;
        this.secret = baseSecret;
        AuthenticatorUtils.update(this, response.getRequest(), response);
    }

    public ChallengeResponse(ChallengeScheme scheme) {
        super(scheme);
        this.identifier = null;
        this.secret = null;
        this.authenticated = false;
        this.clientNonce = null;
        this.digestRef = null;
        this.quality = null;
        this.serverNounceCount = 1;
    }

    @Deprecated
    public ChallengeResponse(ChallengeScheme scheme, String credentials) {
        this(scheme);
        this.setRawValue(credentials);
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, char[] secret) {
        super(scheme);
        this.identifier = identifier;
        this.secret = secret;
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, Series<Parameter> parameters) {
        super(scheme, parameters);
        this.identifier = identifier;
        this.secret = null;
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, String secret) {
        super(scheme);
        this.identifier = identifier;
        this.secret = secret != null ? secret.toCharArray() : null;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj instanceof ChallengeResponse) {
            ChallengeResponse that = (ChallengeResponse)obj;
            if (this.getCredentials() != null) {
                result = this.getCredentials().equals(that.getCredentials());
            } else {
                boolean bl2 = result = that.getCredentials() == null;
            }
            if (result) {
                if (this.getIdentifier() != null) {
                    result = this.getIdentifier().equals(that.getIdentifier());
                } else {
                    boolean bl3 = result = that.getIdentifier() == null;
                }
                if (result) {
                    if (this.getScheme() != null) {
                        result = this.getScheme().equals(that.getScheme());
                    } else {
                        boolean bl4 = result = that.getScheme() == null;
                    }
                    if (result) {
                        if (this.getSecret() == null || that.getSecret() == null) {
                            result = this.getSecret() == that.getSecret();
                        } else if (this.getSecret().length == that.getSecret().length) {
                            boolean equals = true;
                            for (int i = 0; i < this.getSecret().length && equals; ++i) {
                                equals = this.getSecret()[i] == that.getSecret()[i];
                            }
                            result = equals;
                        }
                    }
                }
            }
        }
        return result;
    }

    public String getClientNonce() {
        return this.clientNonce;
    }

    @Deprecated
    public String getCredentials() {
        return this.getRawValue();
    }

    public Reference getDigestRef() {
        return this.digestRef;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Principal getPrincipal() {
        return new Principal(){

            public String getName() {
                return ChallengeResponse.this.getIdentifier();
            }
        };
    }

    public String getQuality() {
        return this.quality;
    }

    public char[] getSecret() {
        return this.secret;
    }

    public int getServerNounceCount() {
        return this.serverNounceCount;
    }

    public String getServerNounceCountAsHex() {
        return AuthenticatorUtils.formatNonceCount(this.getServerNounceCount());
    }

    @Override
    public int hashCode() {
        return SystemUtils.hashCode(this.getScheme(), this.getIdentifier(), this.getCredentials());
    }

    @Deprecated
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Deprecated
    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setClientNonce(String clientNonce) {
        this.clientNonce = clientNonce;
    }

    @Deprecated
    public void setCredentials(String credentials) {
        this.setRawValue(credentials);
    }

    public void setDigestRef(Reference digestRef) {
        this.digestRef = digestRef;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public void setSecret(char[] secret) {
        this.secret = secret;
    }

    public void setSecret(String secret) {
        this.secret = secret == null ? null : secret.toCharArray();
    }

    public void setServerNounceCount(int serverNounceCount) {
        this.serverNounceCount = serverNounceCount;
    }
}

