/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.converter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.Helper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConverterHelper
extends Helper {
    protected List<Class<?>> addObjectClass(List<Class<?>> objectClasses, Class<?> objectClass) {
        if (objectClasses == null) {
            objectClasses = new ArrayList();
        }
        objectClasses.add(objectClass);
        return objectClasses;
    }

    protected List<VariantInfo> addVariant(List<VariantInfo> variants, VariantInfo userVariant) {
        if (userVariant != null) {
            if (variants == null) {
                variants = new ArrayList<VariantInfo>();
            }
            variants.add(userVariant);
        }
        return variants;
    }

    public abstract List<Class<?>> getObjectClasses(Variant var1);

    public abstract List<VariantInfo> getVariants(Class<?> var1);

    public abstract float score(Object var1, Variant var2, UniformResource var3);

    public abstract <T> float score(Representation var1, Class<T> var2, UniformResource var3);

    public abstract <T> T toObject(Representation var1, Class<T> var2, UniformResource var3) throws IOException;

    public abstract Representation toRepresentation(Object var1, Variant var2, UniformResource var3) throws IOException;

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
    }

    public void updatePreferences(List<Preference<MediaType>> preferences, MediaType mediaType, float score) {
        boolean found = false;
        for (int i = 0; !found && i < preferences.size(); ++i) {
            Preference<MediaType> preference = preferences.get(i);
            if (!preference.getMetadata().equals(mediaType) || !(preference.getQuality() < score)) continue;
            preference.setQuality(score);
            found = true;
        }
        if (!found) {
            preferences.add(new Preference<MediaType>(mediaType, score));
        }
    }
}

