/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.service.ConverterService;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInfo {
    private final java.lang.reflect.Method javaMethod;
    private final Class<?> resourceClass;
    private final Method restletMethod;
    private final String value;

    private static Class<?> getJavaActualType(Class<?> currentClass, String genericTypeName) {
        Class<?> result = null;
        result = AnnotationInfo.getJavaActualType(currentClass.getGenericSuperclass(), genericTypeName);
        if (result == null) {
            Type[] interfaceTypes = currentClass.getGenericInterfaces();
            for (int i = 0; result == null && i < interfaceTypes.length; ++i) {
                result = AnnotationInfo.getJavaActualType(interfaceTypes[i], genericTypeName);
            }
        }
        return result;
    }

    private static Class<?> getJavaActualType(Type currentType, String genericTypeName) {
        Class<?> result = null;
        if (currentType != null) {
            if (currentType instanceof Class) {
                result = AnnotationInfo.getJavaActualType((Class)currentType, genericTypeName);
            } else if (currentType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)currentType;
                Class rawType = (Class)parameterizedType.getRawType();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; result == null && i < actualTypeArguments.length; ++i) {
                    if (!genericTypeName.equals(typeParameters[i].getName())) continue;
                    result = AnnotationInfo.getTypeClass(actualTypeArguments[i]);
                }
            }
        }
        return result;
    }

    private static Class<?> getTypeClass(Type type) {
        Type componentType;
        Class<?> componentClass;
        Class<?> result = null;
        if (type instanceof Class) {
            result = (Class<?>)type;
        } else if (type instanceof ParameterizedType) {
            result = AnnotationInfo.getTypeClass(((ParameterizedType)type).getRawType());
        } else if (type instanceof GenericArrayType && (componentClass = AnnotationInfo.getTypeClass(componentType = ((GenericArrayType)type).getGenericComponentType())) != null) {
            result = Array.newInstance(componentClass, 0).getClass();
        }
        return result;
    }

    public AnnotationInfo(Class<?> resourceClass, Method restletMethod, java.lang.reflect.Method javaMethod, String value) {
        this.resourceClass = resourceClass;
        this.restletMethod = restletMethod;
        this.javaMethod = javaMethod;
        this.value = value;
    }

    public boolean equals(Object other) {
        boolean result = other instanceof AnnotationInfo;
        if (result && other != this) {
            AnnotationInfo otherAnnotation = (AnnotationInfo)other;
            if (result) {
                boolean bl = result = this.getJavaMethod() == null && otherAnnotation.getJavaMethod() == null || this.getJavaMethod() != null && this.getJavaMethod().equals(otherAnnotation.getJavaMethod());
            }
            if (result) {
                boolean bl = result = this.getResourceClass() == null && otherAnnotation.getResourceClass() == null || this.getResourceClass() != null && this.getResourceClass().equals(otherAnnotation.getResourceClass());
            }
            if (result) {
                boolean bl = result = this.getRestletMethod() == null && otherAnnotation.getRestletMethod() == null || this.getRestletMethod() != null && this.getRestletMethod().equals(otherAnnotation.getRestletMethod());
            }
            if (result) {
                result = this.getValue() == null && otherAnnotation.getValue() == null || this.getValue() != null && this.getValue().equals(otherAnnotation.getValue());
            }
        }
        return result;
    }

    public String getInputValue() {
        int colonIndex;
        String result = this.getValue();
        if (result != null && (colonIndex = result.indexOf(58)) != -1) {
            result = result.substring(0, colonIndex);
        }
        return result;
    }

    private Class<?> getJavaActualType(Class<?> initialType, Type genericType) {
        Class<?> result = initialType;
        try {
            if (genericType instanceof TypeVariable) {
                TypeVariable genericTypeVariable = (TypeVariable)genericType;
                String genericTypeName = genericTypeVariable.getName();
                result = AnnotationInfo.getJavaActualType(this.getResourceClass(), genericTypeName);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }

    public Class<?> getJavaInputType(int index) {
        return this.getJavaActualType(this.getJavaMethod().getParameterTypes()[index], this.getJavaMethod().getGenericParameterTypes()[index]);
    }

    public Class<?>[] getJavaInputTypes() {
        int count = this.getJavaMethod().getParameterTypes().length;
        Class[] classes = new Class[count];
        for (int i = 0; i < count; ++i) {
            classes[i] = this.getJavaInputType(i);
        }
        return classes;
    }

    public java.lang.reflect.Method getJavaMethod() {
        return this.javaMethod;
    }

    public Class<?> getJavaOutputType() {
        return this.getJavaActualType(this.getJavaMethod().getReturnType(), this.getJavaMethod().getGenericReturnType());
    }

    public String getOutputValue() {
        int colonIndex;
        String result = this.getValue();
        if (result != null && (colonIndex = result.indexOf(58)) != -1) {
            result = result.substring(colonIndex + 1);
        }
        return result;
    }

    public List<Variant> getRequestVariants(MetadataService metadataService, ConverterService converterService) {
        List<? extends Variant> result = null;
        Class<?>[] classes = this.getJavaInputTypes();
        if (classes != null && classes.length >= 1) {
            String[] extensions;
            String value = this.getInputValue();
            if (value != null && (extensions = value.split("\\|")) != null) {
                for (String extension : extensions) {
                    List<MediaType> mediaTypes = metadataService.getAllMediaTypes(extension);
                    if (mediaTypes == null) continue;
                    if (result == null) {
                        result = new ArrayList<Variant>();
                    }
                    for (MediaType mediaType : mediaTypes) {
                        result.add(new Variant(mediaType));
                    }
                }
            }
            if (result == null) {
                Class<?> inputClass = classes[0];
                result = converterService.getVariants(inputClass, null);
            }
        }
        return result;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public List<Variant> getResponseVariants(MetadataService metadataService, ConverterService converterService) {
        List<? extends Variant> result = null;
        if (this.getJavaOutputType() != null && this.getJavaOutputType() != Void.TYPE && this.getJavaOutputType() != Void.class) {
            String value = this.getOutputValue();
            if (value != null) {
                String[] extensions;
                for (String extension : extensions = value.split("\\|")) {
                    List<MediaType> mediaTypes = metadataService.getAllMediaTypes(extension);
                    if (mediaTypes == null) continue;
                    for (MediaType mediaType : mediaTypes) {
                        if (result != null && result.contains(mediaType)) continue;
                        if (result == null) {
                            result = new ArrayList<Variant>();
                        }
                        result.add(new Variant(mediaType));
                    }
                }
            }
            if (result == null) {
                result = converterService.getVariants(this.getJavaOutputType(), null);
            }
        }
        return result;
    }

    public Method getRestletMethod() {
        return this.restletMethod;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isCompatible(Method restletMethod, Representation requestEntity, MetadataService metadataService, ConverterService converterService) {
        return this.getRestletMethod().equals(restletMethod) && this.isCompatibleRequestEntity(requestEntity, metadataService, converterService);
    }

    public boolean isCompatibleRequestEntity(Representation requestEntity, MetadataService metadataService, ConverterService converterService) {
        boolean result = true;
        if (requestEntity != null && requestEntity.isAvailable()) {
            List<Variant> requestVariants = this.getRequestVariants(metadataService, converterService);
            if (requestVariants != null && !requestVariants.isEmpty()) {
                result = false;
                for (int i = 0; !result && i < requestVariants.size(); ++i) {
                    result = requestVariants.get(i).isCompatible(requestEntity);
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    public String toString() {
        return "AnnotationInfo [javaMethod=" + this.javaMethod + ", resourceInterface=" + this.resourceClass + ", restletMethod=" + this.restletMethod + ", value=" + this.value + "]";
    }
}

