/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionHelper;
import org.restlet.engine.connector.ConnectionState;
import org.restlet.engine.connector.Controller;
import org.restlet.util.SelectionListener;
import org.restlet.util.SelectionRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionController
extends Controller
implements Runnable {
    private final Selector selector;
    private final Queue<SelectionRegistration> newRegistrations = new ConcurrentLinkedQueue<SelectionRegistration>();
    private final Queue<SelectionRegistration> updatedRegistrations = new ConcurrentLinkedQueue<SelectionRegistration>();

    public ConnectionController(ConnectionHelper<?> helper) {
        super(helper);
        this.selector = this.createSelector();
    }

    protected void controlConnections() throws IOException {
        for (Connection<?> conn : this.getHelper().getConnections()) {
            if (conn.getState() == ConnectionState.CLOSED) {
                this.getHelper().getConnections().remove(conn);
                this.getHelper().checkin(conn);
                continue;
            }
            if (conn.getState() == ConnectionState.CLOSING && conn.isEmpty()) {
                conn.close(false);
                continue;
            }
            if (conn.hasTimedOut()) {
                if (this.getHelper().getLogger().isLoggable(Level.FINE)) {
                    this.getHelper().getLogger().fine("Closing connection with \"" + conn.getSocketAddress() + "\" due to lack of activity during " + this.getHelper().getMaxIoIdleTimeMs() + " ms");
                }
                conn.close(false);
                continue;
            }
            if (!conn.updateState()) continue;
            this.getUpdatedRegistrations().add(conn.getRegistration());
        }
    }

    protected Selector createSelector() {
        Selector result = null;
        try {
            result = Selector.open();
        }
        catch (IOException ioe) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to open the controller's NIO selector", ioe);
        }
        return result;
    }

    @Override
    protected void doInit() {
        this.getHelper().createConnectionPool();
    }

    @Override
    protected void doRelease() {
        try {
            this.getSelector().close();
        }
        catch (IOException e) {
            this.getHelper().getLogger().log(Level.WARNING, "Unable to close the NIO selector", e);
        }
    }

    @Override
    protected void doRun(long sleepTime) throws IOException {
        super.doRun(sleepTime);
        this.registerKeys();
        this.updateKeys();
        this.selectKeys(sleepTime);
        this.controlConnections();
    }

    protected Queue<SelectionRegistration> getNewRegistrations() {
        return this.newRegistrations;
    }

    protected Selector getSelector() {
        return this.selector;
    }

    protected Queue<SelectionRegistration> getUpdatedRegistrations() {
        return this.updatedRegistrations;
    }

    protected void onSelected(SelectionKey selectedKey) throws ClosedByInterruptException {
        if (selectedKey.attachment() != null) {
            ((SelectionRegistration)selectedKey.attachment()).onSelected(selectedKey.readyOps());
        }
    }

    public SelectionRegistration register(SelectableChannel selectableChannel, int interestOperations, SelectionListener listener) throws IOException {
        SelectionRegistration result = new SelectionRegistration(selectableChannel, interestOperations, listener);
        this.getNewRegistrations().add(result);
        return result;
    }

    protected void registerKeys() {
        SelectionRegistration newRegistration = this.getNewRegistrations().poll();
        while (newRegistration != null) {
            newRegistration.register(this.getSelector());
            newRegistration = this.getNewRegistrations().poll();
        }
    }

    protected void selectKeys(long sleepTime) throws IOException, ClosedByInterruptException {
        if (this.getSelector().select(sleepTime) > 0) {
            Iterator<SelectionKey> keys = this.getSelector().selectedKeys().iterator();
            while (keys.hasNext()) {
                this.onSelected(keys.next());
                keys.remove();
            }
        }
    }

    @Override
    public void shutdown() throws IOException {
        super.shutdown();
        this.getSelector().close();
    }

    protected void updateKeys() throws IOException {
        SelectionRegistration updatedRegistration = this.getUpdatedRegistrations().poll();
        while (updatedRegistration != null) {
            updatedRegistration.update();
            updatedRegistration = this.getUpdatedRegistrations().poll();
        }
    }

    public void wakeup() {
        this.getSelector().wakeup();
    }
}

