/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.MessageState;
import org.restlet.engine.connector.Way;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.io.BufferState;
import org.restlet.engine.io.IoState;
import org.restlet.engine.io.NioUtils;
import org.restlet.engine.io.ReadableBufferedChannel;
import org.restlet.engine.io.ReadableChunkedChannel;
import org.restlet.engine.io.ReadableSizedChannel;
import org.restlet.engine.io.WrapperChannel;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.ReadableRepresentation;
import org.restlet.representation.Representation;
import org.restlet.util.SelectionRegistration;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InboundWay
extends Way {
    private volatile int builderIndex = 0;
    private volatile SelectionRegistration entityRegistration;

    public InboundWay(Connection<?> connection) {
        super(connection, connection.getHelper().getInboundBufferSize());
    }

    @Override
    public void clear() {
        super.clear();
        this.builderIndex = 0;
        this.entityRegistration = null;
    }

    protected Representation createEntity(Series<Parameter> headers) {
        Representation result = null;
        long contentLength = HeaderUtils.getContentLength(headers);
        boolean chunkedEncoding = HeaderUtils.isChunkedEncoding(headers);
        boolean connectionClose = HeaderUtils.isConnectionClose(headers);
        if (contentLength != -1L && contentLength != 0L || chunkedEncoding || connectionClose) {
            WrapperChannel inboundEntityChannel = null;
            ReadableBufferedChannel rbc = new ReadableBufferedChannel(this, this.getByteBuffer(), this.getConnection().getReadableSelectionChannel());
            inboundEntityChannel = chunkedEncoding ? new ReadableChunkedChannel(rbc) : new ReadableSizedChannel(rbc, contentLength);
            this.setEntityRegistration(rbc.getRegistration());
            if (inboundEntityChannel != null) {
                result = new ReadableRepresentation((ReadableByteChannel)((Object)inboundEntityChannel), null, contentLength){

                    public void release() {
                        InboundWay.this.getConnection().close(false);
                    }
                };
                result.setSize(contentLength);
                this.setMessageState(MessageState.BODY);
            }
        } else {
            result = new EmptyRepresentation();
        }
        if (headers != null) {
            try {
                result = HeaderUtils.extractEntityHeaders(headers, result);
            }
            catch (Throwable t) {
                this.getLogger().log(Level.WARNING, "Error while parsing entity headers", t);
            }
        }
        return result;
    }

    protected boolean fillLine() throws IOException {
        this.setLineBuilderState(NioUtils.fillLine(this.getLineBuilder(), this.getLineBuilderState(), this.getByteBuffer()));
        return this.getLineBuilderState() == BufferState.DRAINING;
    }

    protected int getBuilderIndex() {
        return this.builderIndex;
    }

    protected SelectionRegistration getEntityRegistration() {
        return this.entityRegistration;
    }

    @Override
    protected int getSocketInterestOps() {
        int result = 0;
        if (this.getMessageState() == MessageState.BODY && this.getIoState() == IoState.IDLE && this.getEntityRegistration() != null && this.getEntityRegistration().getListener() != null) {
            result = this.getEntityRegistration().getInterestOperations();
        } else if (this.getIoState() == IoState.INTEREST) {
            result = 1;
        }
        return result;
    }

    @Override
    protected boolean isProcessing() {
        return super.isProcessing() && this.getMessageState() != MessageState.BODY;
    }

    @Override
    public void onCompleted(boolean endReached) {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Inbound message fully received");
        }
        super.onCompleted(endReached);
    }

    protected void onReceived() {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Inbound message start line and headers received");
        }
    }

    @Override
    public void onSelected(SelectionRegistration registration) {
        try {
            super.onSelected(registration);
            if (this.getMessageState() == MessageState.BODY && this.getEntityRegistration() != null) {
                this.getEntityRegistration().onSelected(registration.getReadyOperations());
            } else {
                while (this.isProcessing()) {
                    int result = this.readSocketBytes();
                    if (result == 0) {
                        this.setIoState(IoState.INTEREST);
                        continue;
                    }
                    if (result == -1) {
                        this.getConnection().close(true);
                        continue;
                    }
                    while (this.isProcessing() && this.getByteBuffer().hasRemaining()) {
                        this.readMessage();
                    }
                }
            }
        }
        catch (Exception e) {
            this.getConnection().onError("Error while reading a message. Closing the connection.", e, Status.CONNECTOR_ERROR_COMMUNICATION);
        }
    }

    protected Parameter readHeader() throws IOException {
        Parameter header = HeaderReader.readHeader(this.getLineBuilder());
        this.clearLineBuilder();
        return header;
    }

    protected void readMessage() throws IOException {
        while (this.isProcessing() && this.fillLine()) {
            if (this.getMessageState() == MessageState.START) {
                this.readStartLine();
                continue;
            }
            if (this.getMessageState() != MessageState.HEADERS) continue;
            Parameter header = this.readHeader();
            if (header != null) {
                if (this.getHeaders() == null) {
                    this.setHeaders(new Form());
                }
                this.getHeaders().add(header);
                continue;
            }
            this.onReceived();
            if (this.getMessageState() != MessageState.IDLE) continue;
            this.updateState();
            super.onSelected(this.getRegistration());
        }
    }

    protected int readSocketBytes() throws IOException {
        int result = this.getConnection().getReadableSelectionChannel().read(this.getByteBuffer());
        this.getByteBuffer().flip();
        return result;
    }

    protected abstract void readStartLine() throws IOException;

    protected void setBuilderIndex(int builderIndex) {
        this.builderIndex = builderIndex;
    }

    protected void setEntityRegistration(SelectionRegistration entityRegistration) {
        this.entityRegistration = entityRegistration;
    }
}

