/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Status;
import org.restlet.resource.ServerResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Finder
extends Restlet {
    private volatile Class<? extends ServerResource> targetClass;

    public static Finder createFinder(Class<? extends ServerResource> targetClass, Class<? extends Finder> finderClass, Context context, Logger logger) {
        Finder result;
        block8: {
            result = null;
            if (ServerResource.class.isAssignableFrom(targetClass)) {
                if (finderClass != null) {
                    try {
                        Constructor<? extends Finder> constructor = finderClass.getConstructor(Context.class, Class.class);
                        if (constructor != null) {
                            result = constructor.newInstance(context, targetClass);
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        if (logger != null) {
                            logger.log(Level.WARNING, "Exception while instantiating the finder.", e);
                        }
                        break block8;
                    }
                }
                result = new Finder(context, targetClass);
            } else if (logger != null) {
                logger.log(Level.WARNING, "Cannot create a Finder for the given target class, since it is neither a subclass of Resource nor a subclass of ServerResource.");
            }
        }
        return result;
    }

    public Finder() {
        this(null);
    }

    public Finder(Context context) {
        super(context);
        this.targetClass = null;
    }

    public Finder(Context context, Class<? extends ServerResource> targetClass) {
        super(context);
        this.targetClass = targetClass;
    }

    public ServerResource create(Class<? extends ServerResource> targetClass, Request request, Response response) {
        ServerResource result = null;
        if (targetClass != null) {
            try {
                result = targetClass.newInstance();
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Exception while instantiating the target server resource.", e);
            }
        }
        return result;
    }

    public ServerResource create(Request request, Response response) {
        ServerResource result = null;
        if (this.getTargetClass() != null) {
            result = this.create(this.getTargetClass(), request, response);
        }
        return result;
    }

    public ServerResource find(Request request, Response response) {
        return this.create(request, response);
    }

    public Class<? extends ServerResource> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.isStarted()) {
            ServerResource targetResource = this.find(request, response);
            if (targetResource == null) {
                if (this.getLogger().isLoggable(Level.WARNING)) {
                    this.getLogger().warning("No target resource was defined for this finder: " + this.toString());
                }
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            } else {
                targetResource.init(this.getContext(), request, response);
                if (response == null || response.getStatus().isSuccess()) {
                    targetResource.handle();
                }
                targetResource.release();
            }
        }
    }

    public void setTargetClass(Class<? extends ServerResource> targetClass) {
        this.targetClass = targetClass;
    }

    public String toString() {
        return this.getTargetClass() == null ? "Finder with no target class" : "Finder for " + this.getTargetClass().getSimpleName();
    }
}

