/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.IOException;
import java.util.List;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.engine.util.FormUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form
extends Series<Parameter> {
    public Form() {
        super(Parameter.class);
    }

    public Form(int initialCapacity) {
        super(Parameter.class, initialCapacity);
    }

    public Form(List<Parameter> delegate) {
        super(Parameter.class, delegate);
    }

    public Form(Representation webForm) {
        this(webForm, true);
    }

    public Form(Representation webForm, boolean decode) {
        this();
        FormUtils.parse(this, webForm, decode);
    }

    public Form(String queryString) {
        this(queryString, true);
    }

    public Form(String queryString, boolean decode) {
        this(queryString, CharacterSet.UTF_8, decode);
    }

    public Form(String parametersString, char separator) {
        this(parametersString, separator, true);
    }

    public Form(String parametersString, char separator, boolean decode) {
        this(parametersString, CharacterSet.UTF_8, separator, decode);
    }

    public Form(String queryString, CharacterSet characterSet) {
        this(queryString, characterSet, true);
    }

    public Form(String queryString, CharacterSet characterSet, boolean decode) {
        this(queryString, characterSet, '&', decode);
    }

    public Form(String parametersString, CharacterSet characterSet, char separator) {
        this(parametersString, characterSet, separator, true);
    }

    public Form(String parametersString, CharacterSet characterSet, char separator, boolean decode) {
        this();
        FormUtils.parse(this, parametersString, characterSet, decode, separator);
    }

    @Override
    public Parameter createEntry(String name, String value) {
        return new Parameter(name, value);
    }

    public String encode() throws IOException {
        return this.encode(CharacterSet.UTF_8);
    }

    public String encode(CharacterSet characterSet) throws IOException {
        return this.encode(characterSet, '&');
    }

    public String encode(CharacterSet characterSet, char separator) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            ((Parameter)this.get(i)).encode(sb, characterSet);
        }
        return sb.toString();
    }

    public String getMatrixString() {
        return this.getMatrixString(CharacterSet.UTF_8);
    }

    public String getMatrixString(CharacterSet characterSet) {
        try {
            return this.encode(characterSet, ';');
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String getQueryString() {
        return this.getQueryString(CharacterSet.UTF_8);
    }

    public String getQueryString(CharacterSet characterSet) {
        try {
            return this.encode(characterSet);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Representation getWebRepresentation() {
        return this.getWebRepresentation(CharacterSet.UTF_8);
    }

    public Representation getWebRepresentation(CharacterSet characterSet) {
        return new StringRepresentation(this.getQueryString(characterSet), MediaType.APPLICATION_WWW_FORM, null, characterSet);
    }
}

