/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto.internal;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.Reference;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.ext.crypto.DigestAuthenticator;
import org.restlet.ext.crypto.DigestUtils;
import org.restlet.ext.crypto.internal.DigestHelper;
import org.restlet.security.LocalVerifier;
import org.restlet.security.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestVerifier
extends org.restlet.ext.crypto.DigestVerifier<LocalVerifier> {
    private DigestAuthenticator digestAuthenticator;

    public DigestVerifier(DigestAuthenticator digestAuthenticator, LocalVerifier wrappedVerifier, String wrappedAlgorithm) {
        super("HTTP-DIGEST-A1", wrappedVerifier, wrappedAlgorithm);
        this.digestAuthenticator = digestAuthenticator;
    }

    @Override
    protected char[] digest(String identifier, char[] secret, String algorithm) {
        if ("HTTP-DIGEST-A1".equals(algorithm)) {
            String result = DigestUtils.toHttpDigest(identifier, secret, this.getDigestAuthenticator().getRealm());
            if (result != null) {
                return result.toCharArray();
            }
            return null;
        }
        return super.digest(identifier, secret, algorithm);
    }

    public DigestAuthenticator getDigestAuthenticator() {
        return this.digestAuthenticator;
    }

    public void setDigestAuthenticator(DigestAuthenticator digestAuthenticator) {
        this.digestAuthenticator = digestAuthenticator;
    }

    public int verify(Request request, Response response) {
        int result = 4;
        ChallengeResponse cr = request.getChallengeResponse();
        if (cr == null) {
            result = 0;
        } else {
            String nonce = cr.getServerNonce();
            String uri = cr.getDigestRef() == null ? null : cr.getDigestRef().toString();
            String qop = cr.getQuality();
            int nc = cr.getServerNounceCount();
            String cnonce = cr.getClientNonce();
            String username = this.getIdentifier(request, response);
            String cresponse = null;
            char[] secret = this.getSecret(request, response);
            if (secret != null) {
                cresponse = new String(secret);
            } else {
                result = -1;
            }
            try {
                if (!DigestHelper.isNonceValid(nonce, this.getDigestAuthenticator().getServerKey(), this.getDigestAuthenticator().getMaxServerNonceAge())) {
                    result = 1;
                }
            }
            catch (Exception ce) {
                result = -1;
            }
            if (result == 4) {
                if (AuthenticatorUtils.anyNull((Object[])new Object[]{nonce, uri})) {
                    result = 0;
                } else {
                    Reference resourceRef = request.getResourceRef();
                    String requestUri = resourceRef.getPath();
                    if (resourceRef.getQuery() != null && uri.indexOf(63) > -1) {
                        requestUri = requestUri + "?" + resourceRef.getQuery();
                    }
                    if (uri.equals(requestUri)) {
                        char[] a1 = this.getWrappedSecretDigest(username);
                        if (a1 != null) {
                            String a2 = DigestUtils.toMd5(request.getMethod().toString() + ":" + requestUri);
                            StringBuilder expectedResponse = new StringBuilder().append(a1).append(':').append(nonce);
                            if (!AuthenticatorUtils.anyNull((Object[])new Object[]{qop, cnonce, nc})) {
                                expectedResponse.append(':').append(AuthenticatorUtils.formatNonceCount((int)nc)).append(':').append(cnonce).append(':').append(qop);
                            }
                            expectedResponse.append(':').append(a2);
                            if (!DigestUtils.toMd5(expectedResponse.toString()).equals(cresponse)) {
                                result = -1;
                            }
                        } else {
                            result = -1;
                        }
                    } else {
                        result = -1;
                    }
                }
            }
            if (result == 4) {
                request.getClientInfo().setUser(new User(username));
            }
        }
        return result;
    }
}

