/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.grizzly;

import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.filter.SSLReadFilter;
import java.io.File;
import java.net.InetAddress;
import javax.net.ssl.SSLContext;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.security.SslContextFactory;
import org.restlet.engine.security.SslUtils;
import org.restlet.ext.grizzly.GrizzlyServerHelper;
import org.restlet.ext.grizzly.internal.HttpParserFilter;

public class HttpsServerHelper
extends GrizzlyServerHelper {
    public HttpsServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTPS);
    }

    protected void configure(Controller controller) throws Exception {
        SslContextFactory sslContextFactory = SslUtils.getSslContextFactory((RestletHelper)this);
        SSLContext sslContext = sslContextFactory.createSslContext();
        TCPSelectorHandler selectorHandler = this.getSelectorHandler();
        selectorHandler.setPort(((Server)this.getHelped()).getPort());
        if (((Server)this.getHelped()).getAddress() != null) {
            selectorHandler.setInet(InetAddress.getByName(((Server)this.getHelped()).getAddress()));
        }
        final SSLReadFilter readFilter = new SSLReadFilter();
        readFilter.setSSLContext(sslContext);
        String[] enabledCipherSuites = SslUtils.getEnabledCipherSuites((RestletHelper)this);
        if (enabledCipherSuites != null) {
            readFilter.setEnabledCipherSuites(enabledCipherSuites);
        }
        if (this.isNeedClientAuthentication()) {
            readFilter.setNeedClientAuth(this.isNeedClientAuthentication());
        } else if (this.isWantClientAuthentication()) {
            readFilter.setWantClientAuth(this.isWantClientAuthentication());
        }
        final HttpParserFilter httpParserFilter = new HttpParserFilter(this);
        controller.setProtocolChainInstanceHandler((ProtocolChainInstanceHandler)new DefaultProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                ProtocolChain protocolChain = (ProtocolChain)this.protocolChains.poll();
                if (protocolChain == null) {
                    protocolChain = new DefaultProtocolChain();
                    protocolChain.addFilter((ProtocolFilter)readFilter);
                    protocolChain.addFilter((ProtocolFilter)httpParserFilter);
                }
                return protocolChain;
            }
        });
    }

    @Deprecated
    public String getCertAlgorithm() {
        return this.getHelpedParameters().getFirstValue("certAlgorithm", "SunX509");
    }

    @Deprecated
    public String getKeyPassword() {
        return this.getHelpedParameters().getFirstValue("keyPassword", this.getKeystorePassword());
    }

    @Deprecated
    public String getKeystorePassword() {
        return this.getHelpedParameters().getFirstValue("keystorePassword", "");
    }

    @Deprecated
    public String getKeystorePath() {
        return this.getHelpedParameters().getFirstValue("keystorePath", System.getProperty("user.home") + File.separator + ".keystore");
    }

    @Deprecated
    public String getKeystoreType() {
        return this.getHelpedParameters().getFirstValue("keystoreType", "JKS");
    }

    @Deprecated
    public String getSslProtocol() {
        return this.getHelpedParameters().getFirstValue("sslProtocol", "TLS");
    }

    public boolean isNeedClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("needClientAuthentication", "false"));
    }

    public boolean isWantClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("wantClientAuthentication", "false"));
    }
}

