/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.grizzly.internal;

import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.SSLOutputWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.engine.http.ServerCall;
import org.restlet.engine.http.io.ChunkedInputStream;
import org.restlet.engine.http.io.ChunkedOutputStream;
import org.restlet.engine.http.io.ReadableEntityChannel;
import org.restlet.engine.io.NioUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyServerCall
extends ServerCall {
    private final ByteBuffer byteBuffer;
    private final InputReader requestStream;
    private final SocketChannel socketChannel;

    public GrizzlyServerCall(Server server, ByteBuffer byteBuffer, SelectionKey key, boolean confidential) {
        super(server);
        this.setConfidential(confidential);
        this.byteBuffer = byteBuffer;
        this.requestStream = new InputReader();
        this.requestStream.setSelectionKey(key);
        this.requestStream.setByteBuffer(byteBuffer);
        this.socketChannel = (SocketChannel)key.channel();
        this.getRequestHeaders().clear();
        try {
            this.readRequestHead((InputStream)this.requestStream);
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to parse the HTTP request", ioe);
        }
    }

    public void complete() {
    }

    public String getClientAddress() {
        return this.getSocket().getInetAddress().getHostAddress();
    }

    public int getClientPort() {
        return this.getSocket().getPort();
    }

    public ReadableByteChannel getRequestEntityChannel(long size) {
        if (this.isRequestChunked()) {
            return null;
        }
        return new ReadableEntityChannel(this.byteBuffer, (SelectableChannel)this.getSocketChannel(), size);
    }

    public InputStream getRequestEntityStream(long size) {
        if (this.isRequestChunked()) {
            return new ChunkedInputStream(null, (InputStream)this.requestStream);
        }
        return null;
    }

    public ReadableByteChannel getRequestHeadChannel() {
        return this.getSocketChannel();
    }

    public InputStream getRequestHeadStream() {
        return null;
    }

    public WritableByteChannel getResponseEntityChannel() {
        if (this.isResponseChunked()) {
            return null;
        }
        return this.getWritableChannel();
    }

    public OutputStream getResponseEntityStream() {
        if (this.isResponseChunked()) {
            return new ChunkedOutputStream(NioUtils.getStream((WritableByteChannel)this.getWritableChannel()));
        }
        return null;
    }

    private Socket getSocket() {
        return this.getSocketChannel().socket();
    }

    private SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public String getSslCipherSuite() {
        SSLSocket sslSocket;
        SSLSession sslSession;
        Socket socket = this.getSocket();
        if (socket instanceof SSLSocket && (sslSession = (sslSocket = (SSLSocket)socket).getSession()) != null) {
            return sslSession.getCipherSuite();
        }
        return null;
    }

    public List<Certificate> getSslClientCertificates() {
        SSLSocket sslSocket;
        SSLSession sslSession;
        Socket socket = this.getSocket();
        if (socket instanceof SSLSocket && (sslSession = (sslSocket = (SSLSocket)socket).getSession()) != null) {
            try {
                List<Certificate> clientCertificates = Arrays.asList(sslSession.getPeerCertificates());
                return clientCertificates;
            }
            catch (SSLPeerUnverifiedException e) {
                this.getLogger().log(Level.FINE, "Can't get the client certificates.", e);
            }
        }
        return null;
    }

    protected byte[] getSslSessionIdBytes() {
        SSLSocket sslSocket;
        SSLSession sslSession;
        Socket socket = this.getSocket();
        if (socket instanceof SSLSocket && (sslSession = (sslSocket = (SSLSocket)socket).getSession()) != null) {
            return sslSession.getId();
        }
        return null;
    }

    public WritableByteChannel getWritableChannel() {
        if (this.isConfidential()) {
            return new WritableByteChannel(){

                public void close() throws IOException {
                }

                public boolean isOpen() {
                    return GrizzlyServerCall.this.getSocketChannel().isOpen();
                }

                public int write(ByteBuffer src) throws IOException {
                    int nWrite = src.limit();
                    SSLOutputWriter.flushChannel((SelectableChannel)GrizzlyServerCall.this.getSocketChannel(), (ByteBuffer)src);
                    return nWrite;
                }
            };
        }
        return this.getSocketChannel();
    }

    public void writeResponseHead(Response response) throws IOException {
        ByteArrayOutputStream headStream = new ByteArrayOutputStream(8192);
        this.writeResponseHead(response, headStream);
        ByteBuffer buffer = ByteBuffer.wrap(headStream.toByteArray());
        if (this.isConfidential()) {
            SSLOutputWriter.flushChannel((SelectableChannel)this.getSocketChannel(), (ByteBuffer)buffer);
        } else {
            OutputWriter.flushChannel((SelectableChannel)this.getSocketChannel(), (ByteBuffer)buffer);
        }
        buffer.clear();
    }

    public boolean abort() {
        try {
            this.getSocket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

