/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.gwt;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.gwt.ObjectRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_GWT = new VariantInfo(MediaType.APPLICATION_JAVA_OBJECT_GWT);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_GWT.isCompatible(source)) {
            result = this.addObjectClass(result, Serializable.class);
            result = this.addObjectClass(result, ObjectRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (Serializable.class.isAssignableFrom(source) || IsSerializable.class.isAssignableFrom(source) || ObjectRepresentation.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_GWT);
        }
        return result;
    }

    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        if (source instanceof Serializable || source instanceof IsSerializable) {
            result = target == null ? 0.5f : (MediaType.APPLICATION_JAVA_OBJECT_GWT.equals((Object)target.getMediaType()) ? 1.0f : (MediaType.APPLICATION_JAVA_OBJECT_GWT.isCompatible((Metadata)target.getMediaType()) ? 0.6f : 0.5f));
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (source instanceof ObjectRepresentation) {
            result = 1.0f;
        } else if (target != null && ObjectRepresentation.class.isAssignableFrom(target)) {
            result = 1.0f;
        } else if (target != null && (Serializable.class.isAssignableFrom(target) || IsSerializable.class.isAssignableFrom(target))) {
            if (MediaType.APPLICATION_JAVA_OBJECT_GWT.equals((Object)source.getMediaType())) {
                result = 1.0f;
            } else if (MediaType.APPLICATION_JAVA_OBJECT_GWT.isCompatible((Metadata)source.getMediaType())) {
                result = 0.6f;
            }
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        Object result = null;
        if (target != null) {
            if (ObjectRepresentation.class.isAssignableFrom(target)) {
                result = source instanceof ObjectRepresentation ? source : new ObjectRepresentation<T>(source.getText(), target);
            } else if (Serializable.class.isAssignableFrom(target) || IsSerializable.class.isAssignableFrom(target)) {
                result = new ObjectRepresentation<T>(source.getText(), target).getObject();
            }
        } else if (source instanceof ObjectRepresentation) {
            result = ((ObjectRepresentation)source).getObject();
        }
        return (T)result;
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) {
        Representation result = null;
        if (source instanceof Serializable) {
            result = new ObjectRepresentation((Serializable)source);
        } else if (source instanceof IsSerializable) {
            result = new ObjectRepresentation<IsSerializable>((IsSerializable)source);
        } else if (source instanceof Representation) {
            result = (Representation)source;
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        if (Serializable.class.isAssignableFrom(entity) || IsSerializable.class.isAssignableFrom(entity) || ObjectRepresentation.class.isAssignableFrom(entity)) {
            this.updatePreferences(preferences, MediaType.APPLICATION_JAVA_OBJECT_GWT, 1.0f);
        }
    }
}

