/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.javamail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.javamail.MailResolver;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Template;
import org.restlet.util.Resolver;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerResource
extends ServerResource {
    public static final String ATTRIBUTE_MAILBOX_CHALLENGE_SCHEME = "org.restlet.ext.javamail.mailbox.authentication.scheme";
    public static final String ATTRIBUTE_MAILBOX_LOGIN = "org.restlet.ext.javamail.mailbox.login";
    public static final String ATTRIBUTE_MAILBOX_PASSWORD = "org.restlet.ext.javamail.mailbox.password";
    public static final String ATTRIBUTE_MAILBOX_URI = "org.restlet.ext.javamail.mailbox.uri";
    private ChallengeScheme mailboxChallengeScheme;
    private String mailboxLogin;
    private String mailboxPassword;
    private String mailboxUri;
    private String mailUriTemplate;
    private MailResolver resolver;
    private boolean targetEntityEnabled;
    private Method targetMethod;
    private String targetUri;

    @Post
    public void acceptMails(Representation entity) throws ResourceException {
        List<String> mailIdentifiers = this.getMailIdentifiers();
        ArrayList<String> mailsSuccessful = new ArrayList<String>();
        HashMap<String, String> mailsUnsuccessful = new HashMap<String, String>();
        for (String mailIdentifier : mailIdentifiers) {
            try {
                Representation mail = this.getMail(mailIdentifier);
                if (mail == null) continue;
                this.resolver = this.getResolver(mailIdentifier, mail);
                this.callTarget(this.resolver);
                this.deleteMail(mailIdentifier);
                mailsSuccessful.add(mailIdentifier);
            }
            catch (ResourceException e) {
                mailsUnsuccessful.put(mailIdentifier, e.getMessage());
            }
        }
        this.getResponse().setEntity(this.getResponseRepresentation(mailsSuccessful, mailsUnsuccessful));
        this.getResponse().setStatus(this.getResponseStatus(mailsSuccessful, mailsUnsuccessful));
    }

    protected void callTarget(Resolver<String> resolver) throws ResourceException {
        Response response;
        Method method = this.getTargetMethod(resolver);
        Reference targetRef = this.getTargetRef(resolver);
        Request request = new Request(method, targetRef);
        ChallengeResponse challengeResponse = this.getTargetChallengeResponse(resolver);
        if (challengeResponse != null) {
            request.setChallengeResponse(challengeResponse);
        }
        if (this.isTargetEntityEnabled()) {
            request.setEntity(this.getTargetEntity(resolver));
        }
        if (!(response = this.getContext().getClientDispatcher().handle(request)).getStatus().isSuccess()) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Call to the target resource didn't succeed");
        }
    }

    protected void deleteMail(String mailIdentifier) throws ResourceException {
        Response response;
        Reference mailRef = this.getMailRef(mailIdentifier);
        if (mailRef.isRelative()) {
            mailRef.setBaseRef(this.getMailboxUri());
            mailRef = mailRef.getTargetRef();
        }
        Request request = new Request(Method.DELETE, mailRef);
        if (this.getMailboxChallengeScheme() != null) {
            ChallengeResponse challengeResponse = new ChallengeResponse(this.getMailboxChallengeScheme(), this.getMailboxLogin(), this.getMailboxPassword());
            request.setChallengeResponse(challengeResponse);
        }
        if ((response = this.getContext().getClientDispatcher().handle(request)).getStatus().isError()) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Unable to delete the mail from the mailbox");
        }
    }

    protected void doInit() throws ResourceException {
        this.mailboxChallengeScheme = null;
        this.mailboxLogin = null;
        this.mailboxPassword = null;
        this.mailboxUri = null;
        this.mailUriTemplate = "/{mailId}";
        this.resolver = null;
    }

    protected Representation getMail(String identifier) throws ResourceException {
        Response response;
        Reference mailRef = this.getMailRef(identifier);
        Request request = new Request(Method.GET, mailRef);
        if (this.getMailboxChallengeScheme() != null) {
            ChallengeResponse challengeResponse = new ChallengeResponse(this.getMailboxChallengeScheme(), this.getMailboxLogin(), this.getMailboxPassword());
            request.setChallengeResponse(challengeResponse);
        }
        if (!(response = this.getContext().getClientDispatcher().handle(request)).getStatus().isSuccess()) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Unable to get the mail from the mailbox");
        }
        return new DomRepresentation(response.getEntity());
    }

    public ChallengeScheme getMailboxChallengeScheme() {
        if (this.mailboxChallengeScheme == null) {
            this.mailboxChallengeScheme = (ChallengeScheme)this.getContext().getAttributes().get(ATTRIBUTE_MAILBOX_CHALLENGE_SCHEME);
        }
        return this.mailboxChallengeScheme;
    }

    public String getMailboxLogin() {
        if (this.mailboxLogin == null) {
            this.mailboxLogin = (String)this.getContext().getAttributes().get(ATTRIBUTE_MAILBOX_LOGIN);
        }
        return this.mailboxLogin;
    }

    public String getMailboxPassword() {
        if (this.mailboxPassword == null) {
            this.mailboxPassword = (String)this.getContext().getAttributes().get(ATTRIBUTE_MAILBOX_PASSWORD);
        }
        return this.mailboxPassword;
    }

    public String getMailboxUri() {
        if (this.mailboxUri == null) {
            this.mailboxUri = (String)this.getContext().getAttributes().get(ATTRIBUTE_MAILBOX_URI);
        }
        return this.mailboxUri;
    }

    protected List<String> getMailIdentifiers() throws ResourceException {
        Response response;
        ArrayList<String> result = new ArrayList<String>();
        Request request = new Request(Method.GET, this.getMailboxUri());
        if (this.getMailboxChallengeScheme() != null) {
            ChallengeResponse challengeResponse = new ChallengeResponse(this.getMailboxChallengeScheme(), this.getMailboxLogin(), this.getMailboxPassword());
            request.setChallengeResponse(challengeResponse);
        }
        if (!(response = this.getContext().getClientDispatcher().handle(request)).getStatus().isSuccess()) {
            throw new ResourceException(response.getStatus(), "Cannot get the mail iddentifiers.");
        }
        if (response.isEntityAvailable()) {
            DomRepresentation rep = new DomRepresentation(response.getEntity());
            for (Node node : rep.getNodes("/emails/email/@href")) {
                String href = node.getNodeValue();
                if (href.startsWith("/")) {
                    result.add(href.substring(1));
                    continue;
                }
                result.add(href);
            }
        }
        return result;
    }

    protected Reference getMailRef(String identifier) throws ResourceException {
        Template mailTemplate = new Template(this.getMailUriTemplate());
        Reference result = new Reference(mailTemplate.format((Resolver)new MailResolver(identifier)));
        if (result.isRelative()) {
            result.setBaseRef(this.getMailboxUri());
            result = result.getTargetRef();
        }
        return result;
    }

    public String getMailUriTemplate() {
        return this.mailUriTemplate;
    }

    public MailResolver getResolver() {
        return this.resolver;
    }

    protected MailResolver getResolver(String mailIdentifier, Representation email) {
        return new MailResolver(mailIdentifier, email);
    }

    protected Representation getResponseRepresentation(List<String> mailsSuccessful, Map<String, String> mailsUnsuccessful) {
        Representation representation = null;
        return representation;
    }

    protected Status getResponseStatus(List<String> mailsSuccessful, Map<String, String> mailsUnsuccessful) {
        Status status = null;
        status = mailsUnsuccessful.size() > 0 ? Status.CLIENT_ERROR_NOT_FOUND : Status.SUCCESS_OK;
        return status;
    }

    protected ChallengeResponse getTargetChallengeResponse(Resolver<String> resolver) throws ResourceException {
        ChallengeScheme challengeScheme = ChallengeScheme.valueOf((String)((String)resolver.resolve("challengeScheme")));
        String login = (String)resolver.resolve("login");
        String password = (String)resolver.resolve("password");
        ChallengeResponse result = null;
        if (challengeScheme != null && login != null && password != null) {
            result = new ChallengeResponse(challengeScheme, login, password);
        }
        return result;
    }

    protected Representation getTargetEntity(Resolver<String> resolver) {
        return new StringRepresentation((CharSequence)resolver.resolve("message"));
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    protected Method getTargetMethod(Resolver<String> resolver) {
        Method method = Method.valueOf((String)((String)resolver.resolve("method")));
        if (method == null) {
            method = this.getTargetMethod();
        }
        return method;
    }

    protected Reference getTargetRef(Resolver<String> resolver) throws ResourceException {
        Template targetTemplate = new Template(this.getTargetUri());
        Reference result = new Reference(targetTemplate.format(resolver));
        if (result.isRelative()) {
            result.setBaseRef(this.getMailboxUri());
            result = result.getTargetRef();
        }
        return result;
    }

    public String getTargetUri() {
        return this.targetUri;
    }

    public boolean isTargetEntityEnabled() {
        return this.targetEntityEnabled;
    }

    public void setMailboxChallengeScheme(ChallengeScheme mailboxChallengeScheme) {
        this.mailboxChallengeScheme = mailboxChallengeScheme;
    }

    public void setMailboxLogin(String mailboxLogin) {
        this.mailboxLogin = mailboxLogin;
    }

    public void setMailboxPassword(String mailboxPassword) {
        this.mailboxPassword = mailboxPassword;
    }

    public void setMailboxUri(String mailboxUri) {
        this.mailboxUri = mailboxUri;
    }

    public void setMailUriTemplate(String mailUriTemplate) {
        this.mailUriTemplate = mailUriTemplate;
    }

    public void setTargetEntityEnabled(boolean targetEntityEnabled) {
        this.targetEntityEnabled = targetEntityEnabled;
    }

    public void setTargetMethod(Method targetMethod) {
        this.targetMethod = targetMethod;
    }

    public void setTargetUri(String targetUri) {
        this.targetUri = targetUri;
    }
}

