/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxb;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.sax.SAXSource;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.ext.jaxb.internal.Marshaller;
import org.restlet.ext.jaxb.internal.Unmarshaller;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbRepresentation<T>
extends WriterRepresentation {
    private static final ConcurrentMap<String, JAXBContext> contexts = new ConcurrentHashMap<String, JAXBContext>();
    private volatile ClassLoader classLoader;
    private volatile String contextPath;
    private volatile boolean expandingEntityRefs;
    private volatile boolean formattedOutput;
    private volatile boolean fragment;
    private volatile String noNamespaceSchemaLocation;
    private volatile T object;
    private volatile String schemaLocation;
    private boolean secureProcessing;
    private volatile boolean validatingDtd;
    private volatile ValidationEventHandler validationEventHandler;
    private volatile boolean xIncludeAware;
    private volatile Representation xmlRepresentation;

    public static synchronized JAXBContext getContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        JAXBContext result = (JAXBContext)contexts.get(contextPath);
        if (result == null) {
            result = classLoader == null ? JAXBContext.newInstance((String)contextPath) : JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader);
            contexts.put(contextPath, result);
        }
        return result;
    }

    public JaxbRepresentation(MediaType mediaType, T object) {
        this(mediaType, object, object != null ? object.getClass().getClassLoader() : null);
    }

    private JaxbRepresentation(MediaType mediaType, T object, ClassLoader classloader) {
        super(mediaType);
        this.classLoader = classloader;
        this.contextPath = object != null ? object.getClass().getPackage().getName() : null;
        this.object = object;
        this.validationEventHandler = null;
        this.xmlRepresentation = null;
        this.expandingEntityRefs = false;
        this.formattedOutput = false;
        this.fragment = false;
        this.noNamespaceSchemaLocation = null;
        this.schemaLocation = null;
        this.secureProcessing = true;
        this.validatingDtd = false;
        this.xIncludeAware = false;
    }

    public JaxbRepresentation(Representation xmlRepresentation, Class<T> type) {
        this(xmlRepresentation, type.getPackage().getName(), null, type.getClassLoader());
    }

    public JaxbRepresentation(Representation xmlRepresentation, Class<T> type, ValidationEventHandler validationHandler) {
        this(xmlRepresentation, type.getPackage().getName(), validationHandler, type.getClassLoader());
    }

    public JaxbRepresentation(Representation xmlRepresentation, String contextPath) {
        this(xmlRepresentation, contextPath, null, null);
    }

    public JaxbRepresentation(Representation xmlRepresentation, String contextPath, ValidationEventHandler validationHandler) {
        this(xmlRepresentation, contextPath, validationHandler, null);
    }

    private JaxbRepresentation(Representation xmlRepresentation, String contextPath, ValidationEventHandler validationHandler, ClassLoader classLoader) {
        super(xmlRepresentation.getMediaType());
        this.classLoader = classLoader;
        this.contextPath = contextPath;
        this.object = null;
        this.validationEventHandler = validationHandler;
        this.xmlRepresentation = xmlRepresentation;
    }

    public JaxbRepresentation(T object) {
        this(MediaType.APPLICATION_XML, object);
    }

    private ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public JAXBContext getContext() throws JAXBException {
        return JaxbRepresentation.getContext(this.getContextPath(), this.getClassLoader());
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @Deprecated
    public InputSource getInputSource() throws IOException {
        return new InputSource(this.xmlRepresentation.getStream());
    }

    public JAXBSource getJaxbSource() throws IOException {
        try {
            return new JAXBSource(this.getContext(), this.getObject());
        }
        catch (JAXBException e) {
            throw new IOException("JAXBException while creating the JAXBSource: " + e.getMessage());
        }
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public T getObject() throws IOException {
        if (this.object == null && this.xmlRepresentation != null) {
            Unmarshaller u = new Unmarshaller(this.contextPath, this.classLoader);
            if (this.getValidationEventHandler() != null) {
                try {
                    u.setEventHandler(this.getValidationEventHandler());
                }
                catch (JAXBException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to set the event handler", e);
                    throw new IOException("Unable to set the event handler." + e.getMessage());
                }
            }
            try {
                this.object = u.unmarshal(this, this.xmlRepresentation.getReader());
            }
            catch (JAXBException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to unmarshal the XML representation", e);
                throw new IOException("Unable to unmarshal the XML representation." + e.getMessage());
            }
        }
        return this.object;
    }

    @Deprecated
    public SAXSource getSaxSource() throws IOException {
        return this.getJaxbSource();
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    public boolean isExpandingEntityRefs() {
        return this.expandingEntityRefs;
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public boolean isSecureProcessing() {
        return this.secureProcessing;
    }

    public boolean isValidatingDtd() {
        return this.validatingDtd;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setExpandingEntityRefs(boolean expandEntityRefs) {
        this.expandingEntityRefs = expandEntityRefs;
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    public void setNoNamespaceSchemaLocation(String noNamespaceSchemaLocation) {
        this.noNamespaceSchemaLocation = noNamespaceSchemaLocation;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public void setSecureProcessing(boolean secureProcessing) {
        this.secureProcessing = secureProcessing;
    }

    public void setValidatingDtd(boolean validating) {
        this.validatingDtd = validating;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public void setXIncludeAware(boolean includeAware) {
        this.xIncludeAware = includeAware;
    }

    public void write(Writer writer) throws IOException {
        try {
            new Marshaller(this, this.contextPath, this.getClassLoader()).marshal(this.getObject(), writer);
        }
        catch (JAXBException e) {
            Context.getCurrentLogger().log(Level.WARNING, "JAXB marshalling error caught.", e);
            try {
                new Marshaller(this, "failure", this.getClassLoader()).marshal(this.getObject(), writer);
            }
            catch (JAXBException e2) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

