/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxb;

import java.io.IOException;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.jaxb.JaxbRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_ALL_XML = new VariantInfo(MediaType.APPLICATION_ALL_XML);
    private static final VariantInfo VARIANT_APPLICATION_XML = new VariantInfo(MediaType.APPLICATION_XML);
    private static final VariantInfo VARIANT_TEXT_XML = new VariantInfo(MediaType.TEXT_XML);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_APPLICATION_ALL_XML.isCompatible(source) || VARIANT_APPLICATION_XML.isCompatible(source) || VARIANT_TEXT_XML.isCompatible(source)) {
            result = this.addObjectClass(result, JaxbRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (this.isJaxbRootElementClass(source) || JaxbRepresentation.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_APPLICATION_ALL_XML);
            result = this.addVariant(result, VARIANT_APPLICATION_XML);
            result = this.addVariant(result, VARIANT_TEXT_XML);
        }
        return result;
    }

    private boolean isJaxbRootElementClass(Class<?> source) {
        return source != null && source.isAnnotationPresent(XmlRootElement.class);
    }

    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        if (source != null && (source instanceof JaxbRepresentation || this.isJaxbRootElementClass(source.getClass()))) {
            result = target == null ? 0.8f : (MediaType.APPLICATION_ALL_XML.isCompatible((Metadata)target.getMediaType()) ? 1.0f : (MediaType.APPLICATION_XML.isCompatible((Metadata)target.getMediaType()) ? 1.0f : (MediaType.TEXT_XML.isCompatible((Metadata)target.getMediaType()) ? 1.0f : 0.7f)));
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (source != null) {
            if (source instanceof JaxbRepresentation) {
                result = 1.0f;
            } else if (JaxbRepresentation.class.isAssignableFrom(target) || this.isJaxbRootElementClass(target) || JaxbRepresentation.class.isAssignableFrom(source.getClass())) {
                result = 1.0f;
            }
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        JaxbRepresentation<T> result = null;
        if (JaxbRepresentation.class.isAssignableFrom(target)) {
            result = new JaxbRepresentation<T>(source, target);
        } else if (this.isJaxbRootElementClass(target)) {
            result = new JaxbRepresentation<T>(source, target).getObject();
        } else if (target == null && source instanceof JaxbRepresentation) {
            result = ((JaxbRepresentation)source).getObject();
        }
        return target.cast(result);
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) {
        Representation result = null;
        if (this.isJaxbRootElementClass(source.getClass())) {
            result = new JaxbRepresentation(source);
        } else if (source instanceof JaxbRepresentation) {
            result = (Representation)source;
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        if (JaxbRepresentation.class.isAssignableFrom(entity) || this.isJaxbRootElementClass(entity)) {
            this.updatePreferences(preferences, MediaType.APPLICATION_ALL_XML, 1.0f);
            this.updatePreferences(preferences, MediaType.APPLICATION_XML, 1.0f);
            this.updatePreferences(preferences, MediaType.TEXT_XML, 1.0f);
        }
    }
}

