/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;
import org.json.JSONTokener;
import org.restlet.ext.jaxrs.internal.provider.AbstractProvider;
import org.restlet.ext.jaxrs.internal.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class JsonProvider
extends AbstractProvider<Object> {
    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (JSONObject.class.isAssignableFrom(type)) {
            return true;
        }
        if (JSONArray.class.isAssignableFrom(type)) {
            return true;
        }
        return JSONString.class.isAssignableFrom(type);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        final String jsonString = Util.copyToStringBuilder(entityStream).toString();
        try {
            if (JSONObject.class.isAssignableFrom(type)) {
                return new JSONObject(jsonString);
            }
            if (JSONArray.class.isAssignableFrom(type)) {
                return new JSONArray(jsonString);
            }
        }
        catch (JSONException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        if (JSONString.class.isAssignableFrom(type)) {
            return new JSONString(){

                public String toJSONString() {
                    return jsonString;
                }

                public String toString() {
                    return jsonString;
                }
            };
        }
        throw new IllegalArgumentException("the given type " + type + " is not supported");
    }

    @Override
    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(entityStream);
            if (object instanceof JSONString) {
                writer.write(((JSONString)object).toJSONString());
            } else if (object instanceof JSONArray) {
                writer.write(((JSONArray)object).toString());
            } else if (object instanceof CharSequence) {
                writer.write(object.toString());
            } else {
                JSONObject jsonObject = object instanceof JSONObject ? (JSONObject)object : (object instanceof JSONTokener ? new JSONObject((JSONTokener)object) : (object instanceof Map ? new JSONObject((Map)object) : new JSONObject(object)));
                jsonObject.write((Writer)writer);
            }
            writer.flush();
        }
        catch (JSONException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }
}

