/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Variant;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertRepresentationException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalMethodParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnMethodException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.MethodInvokeException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.SortedMetadata;
import org.restlet.ext.jaxrs.internal.wrappers.AbstractMethodWrapper;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceClass;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceMethodOrLocator;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceObject;
import org.restlet.ext.jaxrs.internal.wrappers.WrapperUtil;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;
import org.restlet.ext.jaxrs.internal.wrappers.provider.JaxRsProviders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMethod
extends AbstractMethodWrapper
implements ResourceMethodOrLocator {
    private final java.lang.reflect.Method annotatedMethod;
    private final List<MediaType> consumedMimes;
    private final Method httpMethod;
    private final List<MediaType> producedMimes;
    private final Collection<Variant> supportedVariants;

    ResourceMethod(java.lang.reflect.Method executeMethod, java.lang.reflect.Method annotatedMethod, ResourceClass resourceClass, Method httpMethod, ThreadLocalizedContext tlContext, JaxRsProviders jaxRsProviders, ExtensionBackwardMapping extensionBackwardMapping, Logger logger) throws IllegalPathOnMethodException, IllegalArgumentException, MissingAnnotationException, IllegalMethodParamTypeException, IllegalPathParamTypeException {
        super(executeMethod, annotatedMethod, resourceClass, tlContext, jaxRsProviders, extensionBackwardMapping, true, logger);
        this.annotatedMethod = annotatedMethod;
        this.httpMethod = httpMethod != null ? httpMethod : WrapperUtil.getHttpMethod(this.annotatedMethod);
        this.consumedMimes = this.createConsumedMimes();
        this.producedMimes = this.createProducedMimes();
        this.supportedVariants = this.createSupportedVariants();
    }

    private List<MediaType> createConsumedMimes() {
        Consumes consumes = this.annotatedMethod.getAnnotation(Consumes.class);
        if (consumes == null) {
            consumes = this.executeMethod.getDeclaringClass().getAnnotation(Consumes.class);
        }
        if (consumes != null) {
            return WrapperUtil.convertToMediaTypes(consumes.value());
        }
        return Collections.singletonList(MediaType.ALL);
    }

    private List<MediaType> createProducedMimes() {
        Produces produces = this.annotatedMethod.getAnnotation(Produces.class);
        if (produces == null) {
            produces = this.executeMethod.getDeclaringClass().getAnnotation(Produces.class);
        }
        if (produces != null) {
            return WrapperUtil.convertToMediaTypes(produces.value());
        }
        return Collections.emptyList();
    }

    private Collection<Variant> createSupportedVariants() {
        ArrayList<Variant> supportedVariants = new ArrayList<Variant>();
        for (MediaType mediaType : this.getProducedMimes()) {
            javax.ws.rs.core.MediaType mt = Converter.toJaxRsMediaType(mediaType);
            supportedVariants.add(new Variant(mt, null, null));
        }
        return supportedVariants;
    }

    public Annotation[] getAnnotations() {
        return this.annotatedMethod.getAnnotations();
    }

    public List<MediaType> getConsumedMimes() {
        return this.consumedMimes;
    }

    public Type getGenericReturnType() {
        return this.executeMethod.getGenericReturnType();
    }

    public Method getHttpMethod() {
        return this.httpMethod;
    }

    public List<MediaType> getProducedMimes() {
        return this.producedMimes;
    }

    public Collection<Variant> getSupportedVariants() {
        return this.supportedVariants;
    }

    public Object invoke(ResourceObject resourceObject) throws MethodInvokeException, InvocationTargetException, ConvertRepresentationException, WebApplicationException {
        try {
            return this.internalInvoke(resourceObject);
        }
        catch (IllegalArgumentException e) {
            throw new MethodInvokeException("Could not invoke " + this.executeMethod, e);
        }
        catch (IllegalAccessException e) {
            throw new MethodInvokeException("Could not invoke " + this.executeMethod, e);
        }
    }

    public boolean isAcceptedMediaTypeSupported(SortedMetadata<MediaType> accMediaTypess) {
        if (accMediaTypess == null || accMediaTypess.isEmpty()) {
            return true;
        }
        List<MediaType> prodMimes = this.getProducedMimes();
        if (prodMimes.isEmpty()) {
            return true;
        }
        for (MediaType producedMediaType : prodMimes) {
            for (MediaType accMediaType : accMediaTypess) {
                if (!accMediaType.isCompatible((Metadata)producedMediaType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGivenMediaTypeSupported(MediaType givenMediaType) {
        if (givenMediaType == null) {
            return true;
        }
        for (MediaType consumedMime : this.getConsumedMimes()) {
            if (!consumedMime.includes((Metadata)givenMediaType)) continue;
            return true;
        }
        return false;
    }

    public boolean isHttpMethodSupported(Method requestedMethod) {
        return this.isHttpMethodSupported(requestedMethod, false);
    }

    public boolean isHttpMethodSupported(Method requestedMethod, boolean alsoGet) throws IllegalArgumentException {
        if (requestedMethod == null) {
            throw new IllegalArgumentException("null is not a valid HTTP method");
        }
        if (alsoGet && this.httpMethod.equals((Object)Method.GET)) {
            return true;
        }
        return this.httpMethod.equals((Object)requestedMethod);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.executeMethod.toString() + ", " + this.httpMethod + "]";
    }
}

