/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.restlet.Application;
import org.restlet.ext.jaxrs.internal.provider.AbstractProvider;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.service.ConverterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class ConverterProvider
extends AbstractProvider<Object> {
    private ConverterService converterService;

    public ConverterProvider() {
        Application application = Application.getCurrent();
        if (application != null) {
            this.converterService = application.getConverterService();
        }
        if (this.converterService == null) {
            this.converterService = new ConverterService();
        }
    }

    private ConverterService getConverterService() {
        return this.converterService;
    }

    @Override
    public long getSize(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Variant targetVariant = new Variant(new org.restlet.data.MediaType(mediaType.toString()));
        Representation representation = this.getConverterService().toRepresentation(object, targetVariant, null);
        return representation == null ? -1L : representation.getSize();
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Variant sourceVariant = new Variant(new org.restlet.data.MediaType(mediaType.toString()));
        List classes = this.getConverterService().getObjectClasses(sourceVariant);
        for (Class clazz : classes) {
            if (!clazz.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Variant targetVariant = new Variant(new org.restlet.data.MediaType(mediaType.toString()));
        List variants = this.getConverterService().getVariants(type, targetVariant);
        return variants != null && !variants.isEmpty();
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        InputRepresentation sourceRepresentation = new InputRepresentation(entityStream, new org.restlet.data.MediaType(mediaType.toString()));
        return this.getConverterService().toObject((Representation)sourceRepresentation, type, null);
    }

    @Override
    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Variant targetVariant = new Variant(new org.restlet.data.MediaType(mediaType.toString()));
        Representation representation = this.getConverterService().toRepresentation(object, targetVariant, null);
        if (representation != null) {
            representation.write(entityStream);
        }
    }
}

