/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Providers;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.InjectException;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.ext.jaxrs.internal.wrappers.provider.AbstractProviderWrapper;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ContextResolver;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyReader;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonProvider
extends AbstractProviderWrapper
implements MessageBodyReader,
MessageBodyWriter,
ContextResolver {
    private final javax.ws.rs.ext.ContextResolver<?> contextResolver;
    private final ExceptionMapper<? extends Throwable> excMapper;
    private final Object jaxRsProvider;
    private final javax.ws.rs.ext.MessageBodyReader<?> reader;
    private final javax.ws.rs.ext.MessageBodyWriter<Object> writer;

    public SingletonProvider(Object jaxRsProvider, Logger logger) throws IllegalArgumentException, WebApplicationException {
        super(jaxRsProvider == null ? null : jaxRsProvider.getClass());
        if (jaxRsProvider == null) {
            throw new IllegalArgumentException("The JAX-RS provider class must not be null");
        }
        this.jaxRsProvider = jaxRsProvider;
        boolean isProvider = false;
        if (jaxRsProvider instanceof javax.ws.rs.ext.MessageBodyWriter) {
            this.writer = (javax.ws.rs.ext.MessageBodyWriter)jaxRsProvider;
            isProvider = true;
        } else {
            this.writer = null;
        }
        if (jaxRsProvider instanceof javax.ws.rs.ext.MessageBodyReader) {
            this.reader = (javax.ws.rs.ext.MessageBodyReader)jaxRsProvider;
            isProvider = true;
        } else {
            this.reader = null;
        }
        if (jaxRsProvider instanceof ExceptionMapper) {
            this.excMapper = (ExceptionMapper)jaxRsProvider;
            isProvider = true;
        } else {
            this.excMapper = null;
        }
        if (jaxRsProvider instanceof javax.ws.rs.ext.ContextResolver) {
            this.contextResolver = (javax.ws.rs.ext.ContextResolver)jaxRsProvider;
            isProvider = true;
        } else {
            this.contextResolver = null;
        }
        if (!isProvider) {
            logger.config("The provider " + jaxRsProvider.getClass() + " is neither a MessageBodyWriter nor a MessageBodyReader nor a ContextResolver nor an ExceptionMapper");
        }
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        try {
            return this.getJaxRsReader().isReadable(type, genericType, annotations, mediaType);
        }
        catch (NullPointerException e) {
            if (genericType == null || annotations == null) {
                return false;
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            if (genericType == null || annotations == null) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        try {
            return this.getJaxRsWriter().isWriteable(type, genericType, annotations, mediaType);
        }
        catch (NullPointerException e) {
            if (genericType == null || annotations == null) {
                return false;
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            if (genericType == null || annotations == null) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public final boolean equals(Object otherProvider) {
        if (this == otherProvider) {
            return true;
        }
        if (!(otherProvider instanceof SingletonProvider)) {
            return false;
        }
        return this.jaxRsProvider.getClass().equals(((SingletonProvider)otherProvider).getClass());
    }

    @Override
    public String getClassName() {
        return this.jaxRsProvider.getClass().getName();
    }

    @Override
    public javax.ws.rs.ext.ContextResolver<?> getContextResolver() {
        return this.contextResolver;
    }

    public ExceptionMapper<? extends Throwable> getExcMapper() {
        return this.excMapper;
    }

    @Override
    public MessageBodyReader getInitializedReader() {
        return this;
    }

    @Override
    public MessageBodyWriter getInitializedWriter() {
        return this;
    }

    @Override
    public javax.ws.rs.ext.MessageBodyReader<?> getJaxRsReader() {
        return this.reader;
    }

    public javax.ws.rs.ext.MessageBodyWriter<Object> getJaxRsWriter() {
        return this.writer;
    }

    @Override
    public final int hashCode() {
        return this.jaxRsProvider.hashCode();
    }

    @Override
    public Object readFrom(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, CharacterSet characterSet, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, InvocationTargetException {
        try {
            return this.getJaxRsReader().readFrom(type, genericType, annotations, Converter.toJaxRsMediaType(mediaType), httpHeaders, entityStream);
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof WebApplicationException) {
                throw (WebApplicationException)t;
            }
            throw new InvocationTargetException(t);
        }
    }

    @Override
    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        this.getJaxRsWriter().writeTo(object, type, genericType, annotations, Converter.toJaxRsMediaType(mediaType), httpHeaders, entityStream);
    }

    @Override
    public void initAtAppStartUp(ThreadLocalizedContext tlContext, Providers allProviders, ExtensionBackwardMapping extensionBackwardMapping) throws InjectException, InvocationTargetException, IllegalTypeException {
        this.initProvider(this.jaxRsProvider, tlContext, allProviders, extensionBackwardMapping);
    }

    @Override
    public final boolean isContextResolver() {
        return this.contextResolver != null;
    }

    @Override
    public final boolean isExceptionMapper() {
        return this.excMapper != null;
    }

    @Override
    public final boolean isReader() {
        return this.reader != null;
    }

    @Override
    public final boolean isWriter() {
        return this.writer != null;
    }

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.writer.getSize(t, type, genericType, annotations, Converter.toJaxRsMediaType(mediaType));
    }

    @Override
    public ContextResolver getInitializedCtxResolver() {
        return this;
    }

    @Override
    public ExceptionMapper<? extends Throwable> getInitializedExcMapper() {
        return this.excMapper;
    }

    @Override
    public Class<?> getExcMapperType() {
        return Util.getGenericClass(this.jaxRsProvider.getClass(), ExceptionMapper.class);
    }
}

