/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.core.UriBuilderException;
import org.restlet.Application;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.ext.jaxrs.AbstractUriBuilder;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.service.MetadataService;

public class ExtendedUriBuilder
extends AbstractUriBuilder {
    private String extensionLanguage;
    private String extensionMedia;
    private String extensionOthers;

    public static ExtendedUriBuilder fromPath(String path) throws IllegalArgumentException {
        ExtendedUriBuilder b = ExtendedUriBuilder.newInstance();
        b.replacePath(path);
        return b;
    }

    public static ExtendedUriBuilder fromResource(Class<?> resource) throws IllegalArgumentException {
        ExtendedUriBuilder b = ExtendedUriBuilder.newInstance();
        b.path(resource);
        return b;
    }

    public static ExtendedUriBuilder fromUri(String uri) throws IllegalArgumentException {
        URI u;
        try {
            u = URI.create(uri);
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        return ExtendedUriBuilder.fromUri(u);
    }

    public static ExtendedUriBuilder fromUri(URI uri) throws IllegalArgumentException {
        ExtendedUriBuilder b = ExtendedUriBuilder.newInstance();
        b.uri(uri);
        return b;
    }

    public static ExtendedUriBuilder newInstance() {
        return new ExtendedUriBuilder();
    }

    public ExtendedUriBuilder clone() {
        ExtendedUriBuilder clone = new ExtendedUriBuilder();
        super.copyInto(clone);
        clone.extension(this.getExtension());
        return clone;
    }

    public ExtendedUriBuilder extension(String extensions) {
        if (extensions == null) {
            this.extensionLanguage = null;
            this.extensionMedia = null;
            this.extensionOthers = null;
            return this;
        }
        MetadataService metadataService = Application.getCurrent().getMetadataService();
        StringTokenizer stt = new StringTokenizer(extensions, ".");
        while (stt.hasMoreTokens()) {
            String extension = stt.nextToken();
            Metadata metadata = metadataService.getMetadata(extension);
            if (metadata instanceof Language) {
                this.extensionLanguage = extension;
                continue;
            }
            if (metadata instanceof MediaType) {
                this.extensionMedia = extension;
                continue;
            }
            if (this.extensionOthers == null) {
                this.extensionOthers = extension;
                continue;
            }
            this.extensionOthers = this.extensionOthers + "." + extension;
        }
        return this;
    }

    public ExtendedUriBuilder extensionLanguage(String language) {
        this.extensionLanguage = Util.startsWith(language, '.') ? language.substring(1) : language;
        return this;
    }

    public ExtendedUriBuilder extensionMedia(String mediaExtension) {
        this.extensionMedia = Util.startsWith(mediaExtension, '.') ? mediaExtension.substring(1) : mediaExtension;
        return this;
    }

    @Override
    public ExtendedUriBuilder fragment(String fragment) {
        super.fragment(fragment);
        return this;
    }

    @Override
    public String getExtension() {
        StringBuilder stb = new StringBuilder();
        if (this.extensionOthers != null) {
            stb.append('.');
            stb.append(this.extensionOthers);
        }
        if (this.extensionLanguage != null) {
            stb.append('.');
            stb.append(this.extensionLanguage);
        }
        if (this.extensionMedia != null) {
            stb.append('.');
            stb.append(this.extensionMedia);
        }
        if (stb.length() == 0) {
            return null;
        }
        return stb.toString();
    }

    @Override
    public ExtendedUriBuilder host(String host) throws IllegalArgumentException {
        super.host(host);
        return this;
    }

    @Override
    public ExtendedUriBuilder matrixParam(String name, Object ... values) throws IllegalArgumentException {
        super.matrixParam(name, values);
        return this;
    }

    @Override
    public ExtendedUriBuilder path(Class resource) throws IllegalArgumentException {
        super.path(resource);
        return this;
    }

    @Override
    public ExtendedUriBuilder path(Class resource, String methodName) throws IllegalArgumentException {
        this.path(resource);
        super.path(resource, methodName);
        return this;
    }

    @Override
    public ExtendedUriBuilder path(Method method) throws IllegalArgumentException {
        super.path(method);
        return this;
    }

    @Override
    public ExtendedUriBuilder path(String pathToAppend) throws IllegalArgumentException {
        super.path(pathToAppend);
        return this;
    }

    @Override
    public ExtendedUriBuilder port(int port) throws IllegalArgumentException {
        super.port(port);
        return this;
    }

    @Override
    public ExtendedUriBuilder port(String port) throws IllegalArgumentException {
        super.port(port);
        return this;
    }

    @Override
    public ExtendedUriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        super.queryParam(name, values);
        return this;
    }

    @Override
    public ExtendedUriBuilder replaceMatrix(String matrix) throws IllegalArgumentException {
        super.replaceMatrix(matrix);
        return this;
    }

    @Override
    public ExtendedUriBuilder replaceMatrixParam(String name, Object ... values) throws IllegalArgumentException {
        super.replaceMatrixParam(name, values);
        return this;
    }

    @Override
    public ExtendedUriBuilder replacePath(String newPath) {
        int beginLastSegment;
        if (newPath == null) {
            super.replacePath(newPath);
            this.extension(null);
            return this;
        }
        int beginLastMatrix = newPath.indexOf(59, beginLastSegment = newPath.lastIndexOf(47));
        int endExt = beginLastMatrix > 0 ? beginLastMatrix : newPath.length();
        int beginExtensions = Util.indexOfBetween(newPath, '.', beginLastSegment, endExt);
        if (beginExtensions < 0) {
            super.replacePath(newPath);
            return this;
        }
        String extensions = newPath.substring(beginExtensions, endExt);
        StringBuilder pathStb = new StringBuilder();
        pathStb.append(newPath, 0, beginExtensions);
        pathStb.append(newPath, endExt, newPath.length());
        this.extension(extensions);
        super.replacePath(pathStb);
        return this;
    }

    @Override
    public ExtendedUriBuilder replaceQuery(String query) throws IllegalArgumentException {
        super.replaceQuery(query);
        return this;
    }

    @Override
    public ExtendedUriBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        super.replaceQueryParam(name, values);
        return this;
    }

    @Override
    public ExtendedUriBuilder scheme(String scheme) throws IllegalArgumentException {
        super.scheme(scheme);
        return this;
    }

    @Override
    public ExtendedUriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        super.schemeSpecificPart(ssp);
        return this;
    }

    @Override
    public ExtendedUriBuilder segment(String ... segments) throws IllegalArgumentException {
        super.segment(segments);
        return this;
    }

    @Override
    public ExtendedUriBuilder uri(URI uri) throws IllegalArgumentException {
        super.uri(uri);
        return this;
    }

    @Override
    public ExtendedUriBuilder userInfo(String ui) {
        super.userInfo(ui);
        return this;
    }

    @Override
    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return super.build(values);
    }

    @Override
    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return super.buildFromEncoded(values);
    }

    @Override
    public URI buildFromEncodedMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        return super.buildFromEncodedMap(values);
    }

    @Override
    public URI buildFromMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        return super.buildFromMap(values);
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

