/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers.params;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.restlet.Context;
import org.restlet.ext.jaxrs.ExtendedUriInfo;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedExtendedUriInfo;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedUriInfo;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalBeanSetterTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalFieldTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.ImplementationException;
import org.restlet.ext.jaxrs.internal.exceptions.InjectException;
import org.restlet.ext.jaxrs.internal.todo.NotYetImplementedException;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.ext.jaxrs.internal.wrappers.WrapperUtil;
import org.restlet.ext.jaxrs.internal.wrappers.params.ParameterList;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;

public class ContextInjector {
    private static Logger logger = Context.getCurrentLogger();
    private final List<Injector> injEverSameAims = new ArrayList<Injector>();

    static Object getInjectObject(Class<?> declaringClass, ThreadLocalizedContext tlContext, Providers providers, ExtensionBackwardMapping extensionBackwardMapping) throws IllegalTypeException, ImplementationException {
        if (declaringClass.equals(Providers.class)) {
            return providers;
        }
        if (declaringClass.equals(ContextResolver.class)) {
            throw new IllegalTypeException("The ContextResolver is not allowed for @Context annotated fields yet. Use javax.ws.rs.ext.Providers#getContextResolver(...)");
        }
        if (declaringClass.equals(ExtensionBackwardMapping.class)) {
            return extensionBackwardMapping;
        }
        if (declaringClass.equals(PathSegment.class)) {
            String msg = "The use of PathSegment annotated with @Context is not standard.";
            logger.config(msg);
            return new GetLastPathSegment(tlContext);
        }
        if (declaringClass.equals(SecurityContext.class) || declaringClass.equals(HttpHeaders.class) || declaringClass.equals(Request.class)) {
            return tlContext;
        }
        if (declaringClass.equals(UriInfo.class)) {
            throw new ImplementationException("You must not call the method ContextInjector.getInjectObject(.......) with class UriInfo");
        }
        String declaringClassName = declaringClass.getName();
        if (declaringClassName.equals("javax.servlet.http.HttpServletRequest") || declaringClassName.equals("javax.servlet.http.HttpServletResponse")) {
            throw new NotYetImplementedException("The returnin of Servlet depending Context is not implemented for now.");
        }
        throw new IllegalTypeException(declaringClass + " must not be annotated with @Context");
    }

    static Injector getInjector(Class<?> declaringClass, InjectionAim aim, ThreadLocalizedContext tlContext, Providers allProviders, ExtensionBackwardMapping extensionBackwardMapping) throws IllegalTypeException {
        if (declaringClass.equals(UriInfo.class)) {
            return new UriInfoInjector(aim, tlContext);
        }
        if (declaringClass.equals(ExtendedUriInfo.class)) {
            return new ExtendedUriInfoInjector(aim, tlContext);
        }
        return new EverSameInjector(aim, ContextInjector.getInjectObject(declaringClass, tlContext, allProviders, extensionBackwardMapping));
    }

    public ContextInjector(Class<?> jaxRsClass, ThreadLocalizedContext tlContext, Providers providers, ExtensionBackwardMapping extensionBackwardMapping) throws IllegalFieldTypeException, IllegalBeanSetterTypeException {
        this.init(jaxRsClass, tlContext, providers, extensionBackwardMapping);
    }

    protected void add(AccessibleObject fieldOrBeanSetter, ParameterList.AbstractParamGetter iog) {
        this.injEverSameAims.add(new ParamValueInjector(fieldOrBeanSetter, iog));
    }

    private void init(Class<?> jaxRsClass, ThreadLocalizedContext tlContext, Providers allProviders, ExtensionBackwardMapping extensionBackwardMapping) throws IllegalFieldTypeException, IllegalBeanSetterTypeException {
        do {
            Injector injector;
            InjectionAim aim;
            try {
                for (Field field : jaxRsClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(javax.ws.rs.core.Context.class)) continue;
                    aim = new FieldWrapper(field);
                    Class<?> declaringClass = field.getType();
                    injector = ContextInjector.getInjector(declaringClass, aim, tlContext, allProviders, extensionBackwardMapping);
                    this.injEverSameAims.add(injector);
                }
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (IllegalTypeException e) {
                throw new IllegalFieldTypeException(e);
            }
            try {
                for (AccessibleObject accessibleObject : jaxRsClass.getDeclaredMethods()) {
                    if (!WrapperUtil.isBeanSetter((Method)accessibleObject, javax.ws.rs.core.Context.class)) continue;
                    aim = new BeanSetter((Method)accessibleObject);
                    Class<?> paramClass = ((Method)accessibleObject).getParameterTypes()[0];
                    injector = ContextInjector.getInjector(paramClass, aim, tlContext, allProviders, extensionBackwardMapping);
                    this.injEverSameAims.add(injector);
                }
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (IllegalTypeException e) {
                throw new IllegalBeanSetterTypeException(e);
            }
        } while ((jaxRsClass = jaxRsClass.getSuperclass()) != null);
    }

    public void injectInto(Object jaxRsResObj, boolean allMustBeAvailable) throws InjectException, InvocationTargetException {
        for (Injector injectAim : this.injEverSameAims) {
            injectAim.injectInto(jaxRsResObj, allMustBeAvailable);
        }
    }

    private static final class ExtendedUriInfoInjector
    implements Injector {
        private final InjectionAim aim;
        private final ThreadLocalizedExtendedUriInfo uriInfo;

        ExtendedUriInfoInjector(InjectionAim aim, ThreadLocalizedContext tlContext) {
            this.aim = aim;
            this.uriInfo = new ThreadLocalizedExtendedUriInfo(tlContext);
        }

        @Override
        public void injectInto(Object resource, boolean allMustBeAvailable) throws IllegalArgumentException, InjectException, InvocationTargetException {
            this.uriInfo.saveStateForCurrentThread(allMustBeAvailable);
            this.aim.injectInto(resource, this.uriInfo, allMustBeAvailable);
        }
    }

    private static final class UriInfoInjector
    implements Injector {
        private final InjectionAim aim;
        private final ThreadLocalizedUriInfo uriInfo;

        UriInfoInjector(InjectionAim aim, ThreadLocalizedContext tlContext) {
            this.aim = aim;
            this.uriInfo = new ThreadLocalizedUriInfo(tlContext);
        }

        @Override
        public void injectInto(Object resource, boolean allMustBeAvailable) throws IllegalArgumentException, InjectException, InvocationTargetException {
            this.uriInfo.saveStateForCurrentThread(allMustBeAvailable);
            this.aim.injectInto(resource, this.uriInfo, allMustBeAvailable);
        }
    }

    private class ParamValueInjector
    implements Injector {
        private final AccessibleObject fieldOrBeanSetter;
        private final ParameterList.AbstractParamGetter iog;

        ParamValueInjector(AccessibleObject fieldOrBeanSetter, ParameterList.AbstractParamGetter iog) {
            this.fieldOrBeanSetter = fieldOrBeanSetter;
            this.fieldOrBeanSetter.setAccessible(true);
            this.iog = iog;
        }

        @Override
        public void injectInto(Object resource, boolean allMustBeAvailable) throws IllegalArgumentException, InjectException, InvocationTargetException {
            Util.inject(resource, this.fieldOrBeanSetter, this.iog.getParamValue());
        }
    }

    static interface Injector {
        public void injectInto(Object var1, boolean var2) throws IllegalArgumentException, InjectException, InvocationTargetException;
    }

    static interface InjectionAim {
        public void injectInto(Object var1, Object var2, boolean var3) throws IllegalArgumentException, InjectException, InvocationTargetException;
    }

    private static class GetLastPathSegment
    implements PathSegment {
        private final ThreadLocalizedContext tlContext;

        GetLastPathSegment(ThreadLocalizedContext tlContext) {
            this.tlContext = tlContext;
        }

        private PathSegment getLast() {
            List<PathSegment> pss = this.tlContext.getPathSegments();
            return pss.get(pss.size() - 1);
        }

        public MultivaluedMap<String, String> getMatrixParameters() {
            return this.getLast().getMatrixParameters();
        }

        public String getPath() {
            return this.getLast().getPath();
        }
    }

    static class FieldWrapper
    implements InjectionAim {
        private final Field field;

        private FieldWrapper(Field field) {
            this.field = field;
            this.field.setAccessible(true);
        }

        @Override
        public void injectInto(Object resource, Object toInject, boolean allMustBeAvailable) throws IllegalArgumentException, InjectException, InvocationTargetException {
            Util.inject(resource, this.field, toInject);
        }
    }

    private static class EverSameInjector
    implements Injector {
        private final Object injectable;
        private final InjectionAim injectionAim;

        private EverSameInjector(InjectionAim injectionAim, Object injectable) {
            this.injectionAim = injectionAim;
            this.injectable = injectable;
        }

        @Override
        public void injectInto(Object resource, boolean allMustBeAvailable) throws IllegalArgumentException, InjectException, InvocationTargetException {
            this.injectionAim.injectInto(resource, this.injectable, allMustBeAvailable);
        }
    }

    static class BeanSetter
    implements InjectionAim {
        private final Method beanSetter;

        private BeanSetter(Method beanSetter) {
            this.beanSetter = beanSetter;
            this.beanSetter.setAccessible(true);
        }

        @Override
        public void injectInto(Object resource, Object toInject, boolean allMustBeAvailable) throws IllegalArgumentException, InjectException, InvocationTargetException {
            Util.inject(resource, this.beanSetter, toInject);
        }
    }
}

