/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.SortedMetadata;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyWriter;

public class MessageBodyWriterSubSet {
    private static final MessageBodyWriterSubSet EMPTY = new MessageBodyWriterSubSet(new ArrayList<MessageBodyWriter>(), null, null);
    private final Class<?> type;
    private final Type genericType;
    private final List<MessageBodyWriter> mbws;

    public static MessageBodyWriterSubSet empty() {
        return EMPTY;
    }

    MessageBodyWriterSubSet(List<MessageBodyWriter> mbws, Class<?> type, Type genericType) {
        this.mbws = mbws;
        this.genericType = genericType;
        this.type = type;
    }

    public Collection<MediaType> getAllProducibleMediaTypes() {
        ArrayList<MediaType> p = new ArrayList<MediaType>();
        for (MessageBodyWriter messageBodyWriter : this.mbws) {
            p.addAll(messageBodyWriter.getProducedMimes());
        }
        return p;
    }

    public MessageBodyWriter getBestWriter(MediaType determinedResponseMediaType, Annotation[] annotations, SortedMetadata<MediaType> accMediaTypes) {
        ArrayList<MessageBodyWriter> mbws = new ArrayList<MessageBodyWriter>();
        for (MessageBodyWriter messageBodyWriter : this.mbws) {
            if (!messageBodyWriter.supportsWrite(determinedResponseMediaType) || !messageBodyWriter.isWriteable(this.type, this.genericType, annotations, Converter.toJaxRsMediaType(determinedResponseMediaType))) continue;
            mbws.add(messageBodyWriter);
        }
        for (Iterable iterable : accMediaTypes.listOfColls()) {
            for (MessageBodyWriter mbw : mbws) {
                if (!mbw.supportsWrite(iterable)) continue;
                return mbw;
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return this.mbws.isEmpty();
    }
}

