/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jetty;

import java.io.IOException;
import javax.servlet.ServletException;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.restlet.Server;
import org.restlet.engine.adapter.HttpServerHelper;
import org.restlet.ext.jetty.internal.JettyCall;

public abstract class JettyServerHelper
extends HttpServerHelper {
    private volatile org.eclipse.jetty.server.Server wrappedServer = null;
    private volatile AbstractConnector connector = null;

    public JettyServerHelper(Server server) {
        super(server);
    }

    protected void configure(AbstractConnector connector) {
        if (((Server)this.getHelped()).getAddress() != null) {
            connector.setHost(((Server)this.getHelped()).getAddress());
        }
        connector.setPort(((Server)this.getHelped()).getPort());
        connector.setLowResourcesMaxIdleTime(this.getLowResourcesMaxIdleTimeMs());
        connector.setAcceptors(this.getAcceptorThreads());
        connector.setAcceptQueueSize(this.getAcceptQueueSize());
        connector.setRequestHeaderSize(this.getRequestHeaderSize());
        connector.setResponseHeaderSize(this.getResponseHeaderSize());
        connector.setRequestBufferSize(this.getRequestBufferSize());
        connector.setResponseBufferSize(this.getResponseBufferSize());
        connector.setMaxIdleTime(this.getIoMaxIdleTimeMs());
        connector.setSoLingerTime(this.getSoLingerTime());
    }

    protected abstract AbstractConnector createConnector();

    public int getAcceptorThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("acceptorThreads", "1"));
    }

    public int getAcceptQueueSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("acceptQueueSize", "0"));
    }

    public int getGracefulShutdown() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("gracefulShutdown", "0"));
    }

    public int getIoMaxIdleTimeMs() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("ioMaxIdleTimeMs", "30000"));
    }

    public int getLowResourcesMaxIdleTimeMs() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("lowResourcesMaxIdleTimeMs", "2500"));
    }

    public int getMaxThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxThreads", "255"));
    }

    public int getMinThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("minThreads", "1"));
    }

    public int getRequestBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("requestBufferSize", Integer.toString(8192)));
    }

    public int getRequestHeaderSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("requestHeaderSize", Integer.toString(4096)));
    }

    public int getResponseBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("responseBufferSize", Integer.toString(32768)));
    }

    public int getResponseHeaderSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("responseHeaderSize", Integer.toString(4096)));
    }

    public int getSoLingerTime() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("soLingerTime", "1000"));
    }

    public int getThreadMaxIdleTimeMs() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("threadMaxIdleTimeMs", "60000"));
    }

    protected org.eclipse.jetty.server.Server getWrappedServer() {
        if (this.wrappedServer == null) {
            this.wrappedServer = new WrappedServer(this);
            QueuedThreadPool btp = new QueuedThreadPool();
            btp.setMaxIdleTimeMs(this.getThreadMaxIdleTimeMs());
            btp.setMaxThreads(this.getMaxThreads());
            btp.setMinThreads(this.getMinThreads());
            this.getWrappedServer().setThreadPool((ThreadPool)btp);
            if (this.getGracefulShutdown() > 0) {
                this.getWrappedServer().setGracefulShutdown(this.getGracefulShutdown());
            }
        }
        return this.wrappedServer;
    }

    protected void setWrappedServer(org.eclipse.jetty.server.Server wrappedServer) {
        this.wrappedServer = wrappedServer;
    }

    public void start() throws Exception {
        if (this.connector == null) {
            this.connector = this.createConnector();
            this.configure(this.connector);
            this.getWrappedServer().addConnector((Connector)this.connector);
        }
        this.getWrappedServer().start();
        this.setEphemeralPort(this.connector.getLocalPort());
    }

    public void stop() throws Exception {
        this.getWrappedServer().stop();
    }

    private static class WrappedServer
    extends org.eclipse.jetty.server.Server {
        JettyServerHelper helper;

        public WrappedServer(JettyServerHelper server) {
            this.helper = server;
        }

        public void handle(AbstractHttpConnection connection) throws IOException, ServletException {
            this.helper.handle(new JettyCall((Server)this.helper.getHelped(), connection));
        }
    }
}

