/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jibx;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JibxRepresentation<T>
extends WriterRepresentation {
    private static final Map<String, IBindingFactory> bindingFactories = new TreeMap<String, IBindingFactory>();
    private volatile Class<?> bindingClass;
    private volatile String bindingName;
    private volatile T object;
    private volatile Representation xmlRepresentation;

    private static synchronized IBindingFactory getBindingFactory(String bindingName, Class<?> bindingClass) throws JiBXException {
        IBindingFactory jibxBFact = bindingFactories.get(bindingName + bindingClass.toString());
        if (jibxBFact == null) {
            jibxBFact = bindingName == null ? BindingDirectory.getFactory(bindingClass) : BindingDirectory.getFactory((String)bindingName, bindingClass);
            bindingFactories.put(bindingName + bindingClass.toString(), jibxBFact);
        }
        return jibxBFact;
    }

    public JibxRepresentation(MediaType mediaType, T object) {
        this(mediaType, object, null);
    }

    public JibxRepresentation(MediaType mediaType, T object, String bindingName) {
        super(mediaType);
        this.setCharacterSet(CharacterSet.UTF_8);
        this.object = object;
        this.bindingClass = object.getClass();
        this.bindingName = bindingName;
    }

    public JibxRepresentation(Representation xmlRepresentation, Class<?> bindingClass) {
        this(xmlRepresentation, bindingClass, null);
    }

    public JibxRepresentation(Representation xmlRepresentation, Class<?> bindingClass, String bindingName) {
        super(xmlRepresentation.getMediaType());
        this.xmlRepresentation = xmlRepresentation;
        this.bindingClass = bindingClass;
        this.bindingName = bindingName;
    }

    @Deprecated
    public String getEncoding() {
        return this.getCharacterSet().getName();
    }

    @Deprecated
    public InputSource getInputSource() throws IOException {
        return new InputSource(this.xmlRepresentation.getReader());
    }

    public T getObject() throws JiBXException, IOException {
        if (this.object == null && this.xmlRepresentation != null) {
            IBindingFactory jibxBFact = JibxRepresentation.getBindingFactory(this.bindingName, this.bindingClass);
            IUnmarshallingContext uctx = jibxBFact.createUnmarshallingContext();
            return (T)uctx.unmarshalDocument(this.xmlRepresentation.getStream(), null);
        }
        return this.object;
    }

    @Deprecated
    public void setEncoding(String encoding) {
        this.setCharacterSet(CharacterSet.valueOf((String)encoding));
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void write(Writer writer) throws IOException {
        try {
            IBindingFactory jibxBFact = JibxRepresentation.getBindingFactory(this.bindingName, this.bindingClass);
            IMarshallingContext mctx = jibxBFact.createMarshallingContext();
            mctx.setOutput(writer);
            ((IMarshallable)this.getObject()).marshal(mctx);
        }
        catch (JiBXException e) {
            throw new IOException(e.getMessage());
        }
    }
}

