/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.netty;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.security.SslContextFactory;
import org.restlet.engine.security.SslUtils;
import org.restlet.ext.netty.NettyServerHelper;
import org.restlet.ext.netty.internal.HttpsServerPipelineFactory;

public class HttpsServerHelper
extends NettyServerHelper {
    private SSLContext sslContext;

    public HttpsServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTPS);
    }

    public String getCertAlgorithm() {
        return this.getHelpedParameters().getFirstValue("certAlgorithm", "SunX509");
    }

    public String getKeyPassword() {
        return this.getHelpedParameters().getFirstValue("keyPassword", "");
    }

    public String getKeystorePassword() {
        return this.getHelpedParameters().getFirstValue("keystorePassword", "");
    }

    public String getKeystorePath() {
        return this.getHelpedParameters().getFirstValue("keystorePath", System.getProperty("user.home") + File.separator + ".keystore");
    }

    public String getKeystoreType() {
        return this.getHelpedParameters().getFirstValue("keystoreType", "JKS");
    }

    public ChannelPipelineFactory getPipelineFatory() {
        return new HttpsServerPipelineFactory(this, this.sslContext.createSSLEngine());
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public String getSslProtocol() {
        return this.getHelpedParameters().getFirstValue("sslProtocol", "TLS");
    }

    public boolean isNeedClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("needClientAuthentication", "false"));
    }

    public boolean isWantClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("wantClientAuthentication", "false"));
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void start() throws Exception {
        SslContextFactory sslContextFactory = SslUtils.getSslContextFactory((RestletHelper)this);
        if (sslContextFactory == null) {
            KeyStore keyStore = KeyStore.getInstance(this.getKeystoreType());
            FileInputStream fis = this.getKeystorePath() == null ? null : new FileInputStream(this.getKeystorePath());
            char[] password = this.getKeystorePassword() == null ? null : this.getKeystorePassword().toCharArray();
            keyStore.load(fis, password);
            if (fis != null) {
                fis.close();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.getCertAlgorithm());
            keyManagerFactory.init(keyStore, this.getKeyPassword().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.getCertAlgorithm());
            trustManagerFactory.init(keyStore);
            this.sslContext = SSLContext.getInstance(this.getSslProtocol());
            this.sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        } else {
            this.sslContext = sslContextFactory.createSslContext();
        }
        super.start();
    }
}

