/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.restlet.Server;
import org.restlet.data.Parameter;
import org.restlet.engine.http.HttpServerHelper;
import org.restlet.ext.netty.internal.NettyParams;
import org.restlet.util.Series;

public abstract class NettyServerHelper
extends HttpServerHelper {
    private static final String CHILD_CHANNEL_PREFIX = "child.";
    private static final String RESTLET_NETTY_SERVER = "restlet-netty-server";
    private ChannelGroup allChannels = new DefaultChannelGroup("restlet-netty-server");
    private ChannelFactory factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());

    public NettyServerHelper(Server server) {
        super(server);
    }

    protected abstract ChannelPipelineFactory getPipelineFatory();

    public synchronized void start() throws Exception {
        ServerBootstrap bootstrap = new ServerBootstrap(this.factory);
        bootstrap.setPipelineFactory(this.getPipelineFatory());
        this.setServerParameters(bootstrap);
        int port = ((Server)this.getHelped()).getPort();
        Channel channel = bootstrap.bind((SocketAddress)new InetSocketAddress(port));
        InetSocketAddress address = (InetSocketAddress)channel.getLocalAddress();
        this.setEphemeralPort(address.getPort());
        this.allChannels.add((Object)channel);
        this.getLogger().log(Level.INFO, "Started Netty " + this.getProtocols() + " server on port " + ((Server)this.getHelped()).getPort());
    }

    private void setServerParameters(ServerBootstrap bootstrap) {
        Series options = this.getHelpedParameters();
        for (Parameter option : options) {
            Object value;
            NettyParams param;
            String paramName = option.getName();
            if (paramName.startsWith(CHILD_CHANNEL_PREFIX)) {
                paramName = option.getName().substring(CHILD_CHANNEL_PREFIX.length());
            }
            if ((param = NettyParams.valueOf(paramName)) == null || (value = param.getValue(option.getValue())) == null || !param.isChannelOption().booleanValue()) continue;
            bootstrap.setOption(option.getName(), value);
        }
    }

    public synchronized void stop() throws Exception {
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        this.factory.releaseExternalResources();
        this.getLogger().log(Level.INFO, "Stopped Netty " + this.getProtocols() + " server");
        super.stop();
    }
}

