/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.netty.internal;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.restlet.ext.netty.NettyServerHelper;
import org.restlet.ext.netty.internal.HttpRequestHandler;

public class HttpsServerPipelineFactory
implements ChannelPipelineFactory {
    private final NettyServerHelper helper;
    private final SSLContext sslContext;

    public HttpsServerPipelineFactory(NettyServerHelper serverHelper, SSLContext sslContext) {
        this.helper = serverHelper;
        this.sslContext = sslContext;
    }

    public ChannelPipeline getPipeline() throws Exception {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setUseClientMode(false);
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("streamer", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("handler", (ChannelHandler)new HttpRequestHandler(this.helper));
        return pipeline;
    }
}

