/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.Form;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.OAuthParameters;
import org.restlet.ext.oauth.OAuthUser;
import org.restlet.ext.oauth.internal.CookieCopyClientResource;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Flow {
    NONE,
    PASSWORD,
    REFRESH;


    private static OAuthUser noneFlow(OAuthParameters params, Client c) {
        OAuthUser result = null;
        Form form = new Form();
        form.add("grant_type", GrantType.none.name());
        form.add("client_id", params.getClientId());
        form.add("client_secret", params.getClientSecret());
        if (params.getRoles() != null && params.getRoles().size() > 0) {
            form.add("scope", Scopes.toScope(params.getRoles()));
        }
        CookieCopyClientResource tokenResource = new CookieCopyClientResource(params.getBaseRef() + params.getAccessTokenPath());
        tokenResource.setNext((Uniform)c);
        Context.getCurrentLogger().fine("Sending NoneFlow form : " + form.getQueryString());
        Representation body = tokenResource.post(form.getWebRepresentation());
        if (tokenResource.getStatus().isSuccess()) {
            result = OAuthUser.createJson(body);
        }
        body.release();
        tokenResource.release();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OAuthUser passwordFlow(OAuthParameters params, String username, String password, Client c) {
        OAuthUser result = null;
        Form form = new Form();
        form.add("grant_type", GrantType.password.name());
        form.add("client_id", params.getClientId());
        form.add("client_secret", params.getClientSecret());
        form.add("username", username);
        form.add("password", password);
        CookieCopyClientResource tokenResource = new CookieCopyClientResource(params.getBaseRef() + params.getAccessTokenPath());
        tokenResource.setNext((Uniform)c);
        Context.getCurrentLogger().fine("Sending PasswordFlow form : " + form.getQueryString());
        Representation body = null;
        try {
            body = tokenResource.post(form.getWebRepresentation());
            if (tokenResource.getStatus().isSuccess()) {
                result = OAuthUser.createJson(body);
            }
        }
        finally {
            if (body != null) {
                body.release();
            }
            tokenResource.release();
        }
        return result;
    }

    private static OAuthUser refreshToken(OAuthParameters params, String refreshToken, Client c) {
        OAuthUser result = null;
        CookieCopyClientResource tokenResource = new CookieCopyClientResource(params.getBaseRef() + params.getAccessTokenPath());
        tokenResource.setNext((Uniform)c);
        Form form = new Form();
        form.add("grant_type", GrantType.refresh_token.name());
        form.add("client_id", params.getClientId());
        form.add("client_secret", params.getClientSecret());
        form.add("refresh_token", refreshToken);
        Context.getCurrentLogger().fine("Sending refresh form : " + form.getQueryString());
        Representation body = tokenResource.post(form.getWebRepresentation());
        if (tokenResource.getStatus().isSuccess()) {
            result = OAuthUser.createJson(body);
        }
        body.release();
        tokenResource.release();
        return result;
    }

    public OAuthUser execute(OAuthParameters params, String callbackUri, String state, String username, String password, String refreshToken) {
        return this.execute(params, callbackUri, state, username, password, refreshToken, null);
    }

    public OAuthUser execute(OAuthParameters params, String callbackUri, String state, String username, String password, String refreshToken, Client client) {
        if (this == PASSWORD) {
            return Flow.passwordFlow(params, username, password, client);
        }
        if (this == NONE) {
            return Flow.noneFlow(params, client);
        }
        if (this == REFRESH) {
            return Flow.refreshToken(params, refreshToken, client);
        }
        return null;
    }
}

