/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.io.IOException;
import java.util.StringTokenizer;
import org.restlet.Context;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.engine.header.ChallengeWriter;
import org.restlet.engine.header.Header;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpOAuthHelper
extends AuthenticatorHelper {
    public static String getAuthPage(Context c) {
        return c.getParameters().getFirstValue("authPage", "/auth_page");
    }

    public static String getAuthPageTemplate(Context c) {
        return c.getParameters().getFirstValue("authPageTemplate");
    }

    public static boolean getAuthSkipApproved(Context c) {
        c.getLogger().fine("Trying to get auth page template");
        String skip = c.getParameters().getFirstValue("authSkipApproved");
        if (skip == null) {
            return false;
        }
        return Boolean.parseBoolean(skip);
    }

    public static void setAuthPage(String authPage, Context c) {
        c.getParameters().set("authPage", authPage);
    }

    public static void setAuthPageTemplate(String authPageTemplate, Context c) {
        c.getParameters().set("authPageTemplate", authPageTemplate);
    }

    public static void setAuthSkipApproved(boolean skip, Context c) {
        c.getParameters().set("authSkipApproved", Boolean.toString(skip));
    }

    public HttpOAuthHelper() {
        super(ChallengeScheme.HTTP_OAUTH, true, true);
    }

    public void formatRequest(ChallengeWriter cw, ChallengeRequest challenge, Response response, Series<Header> httpHeaders) throws IOException {
        cw.append((CharSequence)"realm='");
        cw.append((CharSequence)challenge.getRealm());
        cw.append((CharSequence)"'");
        for (Parameter p : challenge.getParameters()) {
            cw.append((CharSequence)", ");
            cw.append((CharSequence)p.getName());
            cw.append((CharSequence)"='");
            cw.append((CharSequence)p.getValue());
            cw.append((CharSequence)"'");
        }
    }

    public void parseRequest(ChallengeRequest challenge, Response response, Series<Header> httpHeaders) {
        String raw = challenge.getRawValue();
        if (raw != null && raw.length() > 0) {
            int eq;
            StringTokenizer st = new StringTokenizer(raw, ",");
            String realm = st.nextToken();
            if (realm != null && realm.length() > 0 && (eq = realm.indexOf(61)) > 0) {
                String value = realm.substring(eq + 1).trim();
                challenge.setRealm(value.substring(1, value.length() - 1));
            }
            Form params = new Form();
            while (st.hasMoreTokens()) {
                int eq2;
                String param = st.nextToken();
                if (param == null || param.length() <= 0 || (eq2 = param.indexOf(61)) <= 0) continue;
                String name = param.substring(0, eq2).trim();
                String value = param.substring(eq2 + 1).trim();
                params.add(name, value.substring(1, value.length() - 1));
            }
            challenge.setParameters((Series)params);
        }
    }
}

