/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.internal.CookieCopyClientResource;
import org.restlet.ext.oauth.internal.JsonStringRepresentation;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.representation.Representation;
import org.restlet.security.Role;
import org.restlet.security.RoleAuthorizer;
import org.restlet.security.User;
import org.restlet.util.Series;

public class OAuthAuthorizer
extends RoleAuthorizer {
    protected final Reference validateRef;
    protected final Client client;
    public static String DEFAULT_OWNER_ATTRIBUTE = "oauth-user";
    private final String ownerAttribute;
    public static String DEFAULT_ROLE_ATTRIBUTE = "oauth-roles";
    private final String roleAttribute;

    protected OAuthAuthorizer() {
        this.validateRef = null;
        this.client = null;
        this.ownerAttribute = DEFAULT_OWNER_ATTRIBUTE;
        this.roleAttribute = DEFAULT_ROLE_ATTRIBUTE;
    }

    public OAuthAuthorizer(Reference validationRef) {
        this(validationRef, null);
    }

    public OAuthAuthorizer(Reference validationRef, Client requestClient) {
        this.validateRef = validationRef;
        this.client = requestClient;
        this.ownerAttribute = DEFAULT_OWNER_ATTRIBUTE;
        this.roleAttribute = DEFAULT_ROLE_ATTRIBUTE;
    }

    public OAuthAuthorizer(String validationRef) {
        this(new Reference(validationRef));
    }

    public OAuthAuthorizer(String validationRef, boolean local, Client requestClient) {
        this(validationRef, local, requestClient, null, null);
    }

    public OAuthAuthorizer(String validationRef, boolean local, Client requestClient, String ownerAttr, String roleAttr) {
        this.client = requestClient;
        this.validateRef = local ? new Reference("riap://application" + validationRef) : new Reference(validationRef);
        this.ownerAttribute = ownerAttr != null ? ownerAttr : DEFAULT_OWNER_ATTRIBUTE;
        this.roleAttribute = roleAttr != null ? roleAttr : DEFAULT_ROLE_ATTRIBUTE;
    }

    public OAuthAuthorizer(String validationRef, Client requestClient) {
        this(validationRef, false, requestClient, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorize(Request req, Response resp) {
        this.getLogger().fine("Checking for param access_token");
        String accessToken = this.getAccessToken(req);
        if (accessToken == null || accessToken.length() == 0) {
            ChallengeRequest cr = new ChallengeRequest(ChallengeScheme.HTTP_OAUTH, "oauth");
            Form parameters = new Form();
            parameters.add("error", OAuthError.invalid_request.name());
            cr.setParameters((Series)parameters);
            resp.getChallengeRequests().add(cr);
            resp.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        } else {
            this.getLogger().fine("Found Access Token " + accessToken);
            CookieCopyClientResource authResource = new CookieCopyClientResource(this.validateRef);
            if (this.client != null) {
                authResource.setNext((Uniform)this.client);
            }
            try {
                JSONObject request = this.createValidationRequest(accessToken, req);
                JsonStringRepresentation repr = new JsonStringRepresentation(request);
                this.getLogger().fine("Posting to validator... json = " + request);
                Representation r = authResource.post((Representation)repr);
                this.getLogger().fine("After posting to validator...");
                repr.release();
                this.getLogger().fine("Got Respose from auth resource OK " + r.getClass().getCanonicalName());
                JsonRepresentation returned = new JsonRepresentation(r);
                JSONObject response = returned.getJsonObject();
                boolean authenticated = response.getBoolean("authenticated");
                if (response.has("tokenOwner")) {
                    this.setUser(req, response, accessToken);
                }
                String error = null;
                if (response.has("error")) {
                    error = response.getString("error");
                }
                this.getLogger().fine("In Auth Filer -> " + authenticated);
                returned.release();
                r.release();
                authResource.release();
                if (authenticated) {
                    boolean bl = true;
                    return bl;
                }
                this.handleError(error, resp);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (authResource != null) {
                    authResource.getResponse().release();
                    authResource.release();
                }
            }
        }
        return false;
    }

    private JSONObject createValidationRequest(String accessToken, Request req) throws JSONException {
        String owner;
        JSONObject request = new JSONObject();
        Reference uri = req.getOriginalRef();
        request.put("access_token", (Object)accessToken);
        List<Role> roles = this.getAuthorizedRoles();
        Object obj = req.getAttributes().get(this.roleAttribute);
        if (obj != null && obj instanceof Role[]) {
            this.getLogger().fine("Found dynamic scopes");
            roles = Arrays.asList((Role[])obj);
        }
        if (roles != null && roles.size() > 0) {
            JSONArray jArray = new JSONArray();
            for (Role r : roles) {
                jArray.put((Object)Scopes.toScope(r));
            }
            request.put("scope", (Object)jArray);
            this.getLogger().fine("Found scopes: " + jArray.toString());
        }
        if ((owner = (String)req.getAttributes().get(this.ownerAttribute)) != null && owner.length() > 0) {
            this.getLogger().fine("Found Owner:" + owner);
            request.put("owner", (Object)owner);
        }
        request.put("uri", (Object)uri.getHierarchicalPart());
        return request;
    }

    private String getAccessToken(Request request) {
        String accessToken = null;
        if (request.getChallengeResponse() != null) {
            accessToken = request.getChallengeResponse().getRawValue();
            this.getLogger().fine("Found Authorization header" + accessToken);
        } else if (accessToken == null || accessToken.length() == 0) {
            Form form;
            Representation r;
            this.getLogger().fine("Didn't contain a Authorization header - checking query");
            accessToken = request.getOriginalRef().getQueryAsForm().getFirstValue("oauth_token");
            if (!(accessToken != null && accessToken.length() != 0 || request.getMethod() != Method.POST && request.getMethod() != Method.PUT && request.getMethod() != Method.DELETE || (r = request.getEntity()) == null || !MediaType.APPLICATION_WWW_FORM.equals((Object)r.getMediaType()) || (accessToken = (form = new Form(r)).getFirstValue("oauth_token")) == null || accessToken.length() <= 0)) {
                request.setEntity(form.getWebRepresentation());
            }
        }
        return accessToken;
    }

    private void handleError(String error, Response resp) {
        if (error != null && error.length() > 0) {
            ChallengeRequest cr = new ChallengeRequest(ChallengeScheme.HTTP_OAUTH, "oauth");
            Form parameters = new Form();
            parameters.add("error", error);
            OAuthError code = OAuthError.valueOf(error);
            switch (code) {
                case invalid_request: {
                    resp.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    break;
                }
                case invalid_token: 
                case expired_token: {
                    resp.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
                    break;
                }
                case insufficient_scope: {
                    resp.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                }
            }
            cr.setParameters((Series)parameters);
            resp.getChallengeRequests().add(cr);
        }
    }

    private void setUser(Request req, JSONObject response, String accessToken) throws JSONException {
        String tokenOwner = response.getString("tokenOwner");
        this.getLogger().fine("User " + tokenOwner + " is accessing : " + req.getOriginalRef());
        User user = new User(tokenOwner, accessToken);
        req.getClientInfo().setUser(user);
        req.getClientInfo().setAuthenticated(true);
    }

    protected int unauthorized(Request request, Response response) {
        return 2;
    }
}

