/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OAuthError {
    access_denied,
    expired_token,
    insufficient_scope,
    invalid_client,
    invalid_grant,
    invalid_request,
    invalid_scope,
    invalid_token,
    redirect_uri_mismatch,
    unauthorized_client,
    unsupported_grant_type,
    unsupported_response_type;


    static JSONObject getErrorMessage(OAuthError error, String description, String errorUri) throws JSONException {
        JSONObject response = new JSONObject();
        response.put("error", (Object)error.name());
        if (description != null && description.length() > 0) {
            response.put("error_description", (Object)description);
        }
        if (errorUri != null && errorUri.length() > 0) {
            response.put("error_uri", (Object)errorUri);
        }
        return response;
    }

    static Form getErrorMessage(OAuthError error, String description, String errorUri, String state) {
        Form response = new Form();
        response.add("error", error.name());
        if (description != null && description.length() > 0) {
            response.add("error_description", description);
        }
        if (errorUri != null && errorUri.length() > 0) {
            response.add("error_uri", errorUri);
        }
        if (state != null && state.length() > 0) {
            response.add("state", state);
        }
        return response;
    }

    static ChallengeRequest getErrorMessage(String realm, OAuthError error, String description, String errorUri, String[] scopes) {
        ChallengeRequest challenge = new ChallengeRequest(ChallengeScheme.HTTP_OAUTH, realm);
        Form response = new Form();
        response.add("error", error.name());
        if (description != null && description.length() > 0) {
            response.add("error_description", description);
        }
        if (errorUri != null && errorUri.length() > 0) {
            response.add("error_uri", errorUri);
        }
        if (scopes != null && scopes.length > 0) {
            StringBuilder scope = new StringBuilder(scopes[0]);
            for (int i = 1; i < scopes.length; ++i) {
                scope.append(' ').append(scopes[i]);
            }
            response.add("scope", scope.toString());
        }
        challenge.setParameters((Series)response);
        return challenge;
    }
}

