/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.CacheDirective;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.util.Base64;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthParameters;
import org.restlet.ext.oauth.OAuthUser;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.CookieCopyClientResource;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ResourceException;
import org.restlet.routing.Filter;
import org.restlet.security.User;

public class OAuthProxy
extends Filter {
    private static final List<CacheDirective> no = new ArrayList<CacheDirective>();
    private static final String VERSION = "DRAFT-10";
    private final OAuthParameters params;
    private final boolean basicSecret;
    private final Client cc;

    public static String getVersion() {
        return VERSION;
    }

    public OAuthProxy(OAuthParameters params, Context ctx) {
        this(params, ctx, false);
    }

    public OAuthProxy(OAuthParameters params, Context ctx, boolean useBasicSecret) {
        this(params, ctx, useBasicSecret, null);
    }

    public OAuthProxy(OAuthParameters params, Context ctx, boolean useBasicSecret, Client requestClient) {
        this.basicSecret = useBasicSecret;
        this.setContext(ctx);
        this.params = params;
        no.add(CacheDirective.noStore());
        this.cc = requestClient;
    }

    protected int beforeHandle(Request request, Response response) {
        Boolean auth = false;
        request.setCacheDirectives(no);
        String redirectUri = request.getResourceRef().toUrl().toString();
        Form query = new Form(request.getOriginalRef().getQuery());
        String error = query.getFirstValue("error");
        if (error != null && error.length() > 0) {
            EmptyRepresentation repr = new EmptyRepresentation();
            String desc = query.getFirstValue("error_description");
            String uri = query.getFirstValue("error_uri");
            if (desc != null || uri != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("<html><body><pre>");
                sb.append("OAuth2 error detected.\n");
                if (desc != null) {
                    sb.append("Error description : ").append(desc);
                }
                if (uri != null) {
                    sb.append("<a href=\"");
                    sb.append(uri);
                    sb.append("\">Error Description</a>");
                }
                sb.append("</pre></body></html>");
                repr = new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML);
            }
            OAuthError ec = OAuthError.valueOf(error);
            switch (ec) {
                case invalid_request: {
                    response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case invalid_client: {
                    response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case unauthorized_client: {
                    response.setStatus(Status.CLIENT_ERROR_FORBIDDEN, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case redirect_uri_mismatch: {
                    response.setStatus(Status.CLIENT_ERROR_FORBIDDEN, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case access_denied: {
                    response.setStatus(Status.CLIENT_ERROR_FORBIDDEN, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case unsupported_response_type: {
                    response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case invalid_scope: {
                    response.setStatus(Status.CLIENT_ERROR_FORBIDDEN, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                default: {
                    this.getLogger().warning("Unhandled error response type. " + ec.name());
                }
            }
            return 2;
        }
        String code = query.getFirstValue("code");
        this.getLogger().fine("Incomming request query = " + query);
        if (code == null) {
            Form form = new Form();
            form.add("response_type", ResponseType.code.name());
            form.add("client_id", this.params.getClientId());
            form.add("redirect_uri", redirectUri);
            form.add("scope", Scopes.toScope(this.params.getRoles()));
            try {
                form.encode();
            }
            catch (IOException ioe) {
                this.getLogger().warning(ioe.getMessage());
            }
            String q = form.getQueryString();
            Reference redirRef = new Reference(this.params.getBaseRef(), this.params.getAuthorizePath(), q, null);
            this.getLogger().fine("Redirecting to : " + redirRef.toUri());
            response.setCacheDirectives(no);
            response.redirectTemporary(redirRef);
            this.getLogger().fine("After Redirecting to : " + redirRef.toUri());
        } else {
            this.getLogger().fine("Came back after SNS code = " + code);
            CookieCopyClientResource tokenResource = new CookieCopyClientResource(this.params.getBaseRef() + this.params.getAccessTokenPath());
            if (this.cc != null) {
                tokenResource.setNext((Uniform)this.cc);
            }
            Form form = new Form();
            form.add("grant_type", GrantType.authorization_code.name());
            String redir = request.getResourceRef().getHostIdentifier() + request.getResourceRef().getPath();
            form.add("redirect_uri", redir);
            if (this.basicSecret) {
                ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC);
                authentication.setDigestAlgorithm("NONE");
                String basic = this.params.getClientId() + ':' + this.params.getClientSecret();
                authentication.setRawValue(Base64.encode((byte[])basic.getBytes(), (boolean)false));
                tokenResource.setChallengeResponse(authentication);
            } else {
                form.add("client_id", this.params.getClientId());
                form.add("client_secret", this.params.getClientSecret());
            }
            form.add("code", code);
            this.getLogger().fine("Sending access form : " + form.getQueryString() + " to : " + tokenResource.getReference());
            try {
                OAuthUser authUser;
                Representation input = form.getWebRepresentation();
                Representation body = tokenResource.post(input);
                if (tokenResource.getStatus().isSuccess() && (authUser = OAuthUser.createJson(request.getClientInfo().getUser(), body)) != null) {
                    request.getClientInfo().setUser((User)authUser);
                    request.getClientInfo().setAuthenticated(true);
                    this.getLogger().fine("storing to context = : " + this.getContext());
                    auth = true;
                }
                this.getLogger().fine("Before sns release");
                body.release();
            }
            catch (ResourceException re) {
                this.getLogger().warning("Could not find token resource.");
            }
            tokenResource.release();
        }
        if (auth.booleanValue()) {
            return 0;
        }
        if (response.getStatus().isSuccess() || response.getStatus().isServerError()) {
            response.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
        }
        return 2;
    }

    public synchronized void start() throws Exception {
        super.start();
    }

    public synchronized void stop() throws Exception {
        super.stop();
    }
}

