/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.HttpOAuthHelper;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.routing.Redirector;
import org.restlet.security.Role;

@Deprecated
public class AuthorizationServerResourceOld
extends OAuthServerResource {
    public static final String ID = "id";
    public static final String OPENID = "openid";

    @Get(value="html")
    @Post(value="html")
    public Representation represent() {
        Form params = this.getQuery();
        String sessionId = this.getCookies().getFirstValue("_cid");
        this.getLogger().fine("sessionId = " + sessionId);
        ConcurrentMap attribs = this.getContext().getAttributes();
        AuthSession session = sessionId == null ? null : (AuthSession)attribs.get(sessionId);
        String id = (String)this.getContext().getAttributes().get(ID);
        this.getLogger().fine("id = " + id);
        this.getLogger().fine("session = " + session);
        if (session != null) {
            this.getLogger().fine("client = " + session.getClient());
        } else {
            this.getCookieSettings().removeAll("_cid");
        }
        if (id != null && session != null && session.getClient() != null) {
            this.getLogger().fine("After Authentication - cleanup");
            params.removeFirst(OPENID);
            Client client = session.getClient();
            this.getLogger().fine("Found client = " + client);
            session.setScopeOwner(id);
            return this.doPostAuthenticate(session, client);
        }
        String typeString = params.getFirstValue("response_type");
        this.getLogger().fine("In service type = " + typeString);
        try {
            ResponseType type = Enum.valueOf(ResponseType.class, typeString);
            this.getLogger().fine("Found flow - " + (Object)((Object)type));
            if (Method.GET.equals((Object)this.getMethod())) {
                this.doGet(type, session);
            } else {
                this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
        }
        catch (IllegalArgumentException iae) {
            this.sendError(sessionId, OAuthError.unsupported_response_type, params.getFirstValue("state"), "Unsupported flow", null);
            this.getLogger().log(Level.WARNING, "Error in execution.", iae);
        }
        catch (NullPointerException npe) {
            this.sendError(sessionId, OAuthError.invalid_request, params.getFirstValue("state"), "No response_type parameter found.", null);
        }
        return this.getResponseEntity();
    }

    protected void doGet(ResponseType flow, AuthSession session) {
        this.getLogger().fine("doGet()");
        Form params = this.getQuery();
        String clientId = params.getFirstValue("client_id");
        String sessionId = null;
        if (session != null) {
            sessionId = session.getId();
        }
        if (clientId != null && clientId.length() > 0) {
            try {
                this.doServerFlow(flow, clientId, session);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error in execution.", e);
                this.setStatus(Status.SERVER_ERROR_INTERNAL);
                this.getLogger().log(Level.WARNING, "", e);
            }
        } else {
            this.sendError(sessionId, OAuthError.invalid_request, params.getFirstValue("state"), "No client_id parameter found.", null);
            this.getLogger().warning("Could not find client ID");
        }
    }

    private void doServerFlow(ResponseType flow, String clientId, AuthSession session) {
        Form params = this.getQuery();
        String redirUri = params.getFirstValue("redirect_uri");
        String sessionId = null;
        if (session != null) {
            sessionId = session.getId();
        }
        if (redirUri == null || redirUri.length() == 0) {
            this.sendError(sessionId, OAuthError.invalid_request, params.getFirstValue("state"), "No redirect_uri parameter found.", null);
            this.getLogger().warning("No mandatory redirect URI provided");
            return;
        }
        Client client = this.clients.findById(clientId);
        this.getLogger().fine("Client = " + client);
        if (client == null) {
            this.sendError(sessionId, OAuthError.invalid_request, params.getFirstValue("state"), "Need to register the client : " + clientId, null);
            this.getLogger().warning("Need to register the client : " + clientId);
            return;
        }
        this.getLogger().fine("Compare client redir:provided redir = " + client.getRedirectUri() + ":" + redirUri);
        if (!redirUri.startsWith(client.getRedirectUri())) {
            this.sendError(sessionId, OAuthError.redirect_uri_mismatch, params.getFirstValue("state"), "Callback URI does not match.", null);
            this.getLogger().warning("Callback URI does not match.");
            return;
        }
        if (session != null && session.getScopeOwner() != null) {
            if (flow.equals((Object)ResponseType.token) || flow.equals((Object)ResponseType.code)) {
                String state;
                String[] requestedScopes;
                for (String scope : requestedScopes = this.parseScope(params.getFirstValue("scope"))) {
                    this.getLogger().fine("Requested scopes = " + scope);
                }
                session.setClient(client);
                session.setAuthFlow(flow);
                session.setRequestedScope(requestedScopes);
                if (!redirUri.equals(client.getRedirectUri())) {
                    session.setDynamicCallbackURI(redirUri);
                    this.getLogger().fine("OAuth2 set dynamic callback = " + redirUri);
                }
                if ((state = this.getCookies().getFirstValue("state")) != null && state.length() > 0) {
                    session.setState(state);
                }
                this.getResponse().setEntity(this.doPostAuthenticate(session, client));
                return;
            }
        } else {
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
        }
    }

    protected Representation doPostAuthenticate(AuthSession session, Client client) {
        List<Role> roles;
        AuthenticatedUser user;
        Reference ref = new Reference("riap://application/" + HttpOAuthHelper.getAuthPage(this.getContext()));
        this.getLogger().fine("Name = " + this.getApplication().getInboundRoot());
        ref.addQueryParameter("client", client.getClientId());
        String[] scopes = session.getRequestedScope();
        if (scopes != null && scopes.length > 0) {
            for (String s : scopes) {
                ref.addQueryParameter("scope", s);
            }
        }
        if ((user = client.findUser(session.getScopeOwner())) != null && (roles = user.getGrantedRoles()) != null && roles.size() > 0) {
            for (Role r : roles) {
                ref.addQueryParameter("grantedScope", Scopes.toScope(r));
            }
        }
        this.getLogger().fine("Redir = " + ref);
        Redirector dispatcher = new Redirector(this.getContext(), ref.toString(), 6);
        dispatcher.handle(this.getRequest(), this.getResponse());
        return this.getResponseEntity();
    }

    public void sendError(String sessionId, OAuthError error, String state) {
        this.sendError(sessionId, error, state, null, null);
    }

    public void sendError(String sessionId, OAuthError error, String state, String description, String errorUri) {
        Form params = this.getQuery();
        String redirUri = params.getFirstValue("redirect_uri");
        if (redirUri == null || redirUri.length() == 0) {
            redirUri = "https://127.0.0.1/cb";
        }
        Reference cb = new Reference(redirUri);
        cb.addQueryParameter("error", error.name());
        if (state != null && state.length() > 0) {
            cb.addQueryParameter("state", state);
        }
        if (description != null && description.length() > 0) {
            cb.addQueryParameter("error_description", description);
        }
        if (errorUri != null && errorUri.length() > 0) {
            cb.addQueryParameter("error_uri", errorUri);
        }
        this.redirectTemporary(cb.toString());
        if (sessionId != null && sessionId.length() > 0) {
            ConcurrentMap attribs = this.getContext().getAttributes();
            attribs.remove(sessionId);
        }
    }
}

