/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.ClientStore;
import org.restlet.ext.oauth.internal.ClientImpl;
import org.restlet.ext.oauth.internal.MemTokenGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemClientStore
extends ClientStore<MemTokenGenerator> {
    private final Map<String, Client> clients = new ConcurrentHashMap<String, Client>();

    public MemClientStore() {
        super(new MemTokenGenerator(new ScheduledThreadPoolExecutor(5)));
    }

    public MemClientStore(ScheduledThreadPoolExecutor executor) {
        super(new MemTokenGenerator(executor));
    }

    @Override
    public Client createClient(String clientId, String redirectUri) {
        return this.createClient(clientId, null, redirectUri);
    }

    @Override
    public Client createClient(String clientId, String clientSecret, String redirectUri) {
        ClientImpl client = new ClientImpl(clientId, clientSecret, redirectUri);
        this.clients.put(clientId, client);
        return client;
    }

    @Override
    public void deleteClient(String id) {
        this.clients.remove(id);
    }

    @Override
    public Client findById(String id) {
        return this.clients.get(id);
    }

    @Override
    public Collection<Client> findClientsForUser(String userid) {
        ArrayList<Client> result = new ArrayList<Client>();
        for (Client c : this.clients.values()) {
            if (!c.containsUser(userid)) continue;
            result.add(c);
        }
        return result;
    }
}

