/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.internal.ExpireToken;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.ext.oauth.internal.TokenGenerator;

public class MemTokenGenerator
extends TokenGenerator {
    private final Map<String, AuthenticatedUser> codeStore = new ConcurrentHashMap<String, AuthenticatedUser>();
    private final Map<String, Token> tokenStore = new ConcurrentHashMap<String, Token>();
    private final ScheduledThreadPoolExecutor timers;

    public MemTokenGenerator(ScheduledThreadPoolExecutor executor) {
        this.timers = executor;
    }

    public String generateCode(AuthenticatedUser user) {
        String code = super.generateCode(user);
        AuthenticatedUser oldValue = this.codeStore.put(code, user);
        if (oldValue != null) {
            oldValue.setCode(code);
        }
        return code;
    }

    public Token generateToken(AuthenticatedUser user, long expire) {
        Token t = super.generateToken(user, expire);
        if (expire != 0L) {
            ExpireToken et = (ExpireToken)t;
            this.tokenStore.put(et.getRefreshToken(), et);
            this.scheduleCleanup(et, expire);
        }
        this.tokenStore.put(t.getToken(), t);
        return t;
    }

    public Token exchangeForToken(String code, long expire) throws IllegalArgumentException {
        AuthenticatedUser user = this.codeStore.remove(code);
        if (user == null) {
            throw new IllegalArgumentException("Code not valid");
        }
        Token t = this.generateToken(user, expire);
        user.clearCode();
        return t;
    }

    public void revokeToken(Token token) {
        String id = token.getToken();
        if (id != null && this.tokenStore.containsKey(id)) {
            this.tokenStore.remove(token.getToken());
        }
    }

    public void revokeExpireToken(ExpireToken token) {
        if (this.tokenStore.containsKey(token.getRefreshToken())) {
            Token t = this.tokenStore.remove(token.getRefreshToken());
            this.revokeToken(t);
        }
    }

    public Token findToken(String token) {
        return this.tokenStore.get(token);
    }

    public void refreshToken(ExpireToken token) {
        super.refreshToken(token);
        this.scheduleCleanup(token, token.getExpirePeriod());
        this.tokenStore.put(token.getToken(), token);
    }

    private void scheduleCleanup(final ExpireToken et, long expire) {
        Runnable r = new Runnable(){

            public void run() {
                String token = et.getToken();
                MemTokenGenerator.this.tokenStore.remove(token);
                et.expireToken();
            }
        };
        ScheduledFuture<?> future = this.timers.schedule(r, expire, TimeUnit.SECONDS);
        et.setFuture(future);
    }
}

