/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.restlet.security.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scopes {
    public static String toScope(List<Role> roles) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        for (Role r : roles) {
            String scope = Scopes.toScope(r);
            sb.append(' ');
            sb.append(scope);
        }
        return sb.substring(1);
    }

    public static String toScope(Role r) throws IllegalArgumentException {
        String rname = r.getName();
        if (rname == null) {
            throw new IllegalArgumentException("Role name cannot be null");
        }
        if ((rname = rname.trim()).length() < 1) {
            throw new IllegalArgumentException("Role name cannot be empty");
        }
        if (rname.contains(" ")) {
            throw new IllegalArgumentException("Role name cannot contain space");
        }
        return rname;
    }

    public static Role toRole(String scope) {
        return new Role(scope, null);
    }

    public static List<Role> toRoles(String scopes) {
        String[] tmp = Scopes.parseScope(scopes);
        ArrayList<Role> toRet = new ArrayList<Role>(tmp.length);
        for (String scope : tmp) {
            toRet.add(new Role(scope, null));
        }
        return toRet;
    }

    public static String[] parseScope(String scopes) {
        if (scopes != null && scopes.length() > 0) {
            StringTokenizer st = new StringTokenizer(scopes, " ");
            String[] scope = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                scope[i] = st.nextToken();
                ++i;
            }
            return scope;
        }
        return new String[0];
    }
}

