/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.internal.AuthenticatedUserImpl;

public class ClientImpl
extends Client {
    private final String clientId;
    private final String clientSecret;
    private final String redirectUri;
    private final Set<AuthenticatedUser> users;
    private final String applicationName;

    public ClientImpl(String clientId, String redirectUri) {
        this(clientId, null, redirectUri, null);
    }

    public ClientImpl(String clientId, String clientSecret, String redirectUri) {
        this(clientId, clientSecret, redirectUri, null);
    }

    public ClientImpl(String clientId, String clientSecret, String redirectUri, String name) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.applicationName = name;
        this.users = Collections.synchronizedSet(new HashSet());
    }

    public boolean containsUser(String userId) {
        return this.users.contains(new AuthenticatedUserImpl(userId, this));
    }

    public AuthenticatedUser createUser(String id) {
        AuthenticatedUserImpl user = new AuthenticatedUserImpl(id, this);
        this.users.add(user);
        return user;
    }

    public AuthenticatedUser findUser(String id) {
        if (id != null && id.length() > 0) {
            for (AuthenticatedUser user : this.users) {
                if (!user.getId().equals(id)) continue;
                return user;
            }
        }
        return null;
    }

    public void revokeUser(String id) {
        this.users.remove(new AuthenticatedUserImpl(id, this));
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String toString() {
        if (this.applicationName != null && this.applicationName.length() > 0) {
            return "Application = " + this.applicationName + " CB = " + this.redirectUri;
        }
        return "ClientId = " + this.clientId + " CB = " + this.redirectUri;
    }
}

